### Name: getPROBESET
### Title: Find probe set IDs
### Aliases: getPROBESET
### Keywords: manip

### ** Examples

##example Affymetrix annotation file and its location
annotationFile<-'HG-U133_Plus_2_annot_part.csv'
dataDirectory<-system.file('data',package='annotationTools')

##load annotation file
annotation<-read.csv(paste(dataDirectory,annotationFile,sep='/'),colClasses='character')

##genes of interest
myGenes<-c('DDR1','GUCA1A','HSPA6',NA,'XYZ')

##column 15 in annotation contains gene symbols
colnames(annotation)

##find probe sets probing for particular genes 
getPROBESET(myGenes,annotation,idCol=15)

##find probe sets probing only for the genes of interest (i.e. with unique annotation)
getPROBESET(myGenes,annotation,idCol=15,uniqueID=TRUE)

##track origin of annotation failure for the 2 last probe set IDs
getPROBESET(myGenes,annotation,idCol=15,diagnose=TRUE)



