### Name: getHOMOLOG
### Title: Find homologous/orthologous gene (ID)
### Aliases: getHOMOLOG
### Keywords: manip

### ** Examples

##example Homologene file and its location
homologeneFile<-'homologene_part.data'
dataDirectory<-system.file('data',package='annotationTools')

##load Homologene file
homologene<-read.delim(paste(dataDirectory,homologeneFile,sep='/'),header=FALSE)

##get mouse (species ID 10090) orthologs of several human (species ID 9606) gene ID (among those: 5982, gene symbol RFC2 and 93587, gene symbol: RG9MTD2)
myGenes<-c(5982,93587,NA,100)
getHOMOLOG(myGenes,10090,homologene)

##track origin of annotation failure for the last 2 gene IDs
getHOMOLOG(myGenes,10090,homologene,diagnose=TRUE)

##get mouse gene belonging to homologene cluster IDs 6885 and 6886
myClusters<-c(6885,6886)
getHOMOLOG(myClusters,10090,homologene,cluster=TRUE)

##mine Affymetrix (example) ortholog file
affyOrthologFile<-'HG-U133_Plus_2_ortholog_part.csv'
affyOrthologs<-read.csv(paste(dataDirectory,affyOrthologFile,sep='/'),colClasses='character')

##get Mouse430_2 probe set IDs 'orthologous' to HG-U133_Plus_2 probe set IDs 1053_at and 121_at
myPS<-c('1053_at','121_at')
getHOMOLOG(myPS,'Mouse430_2',affyOrthologs,cluster=TRUE,clusterCol=1,speciesCol=4,idCol=3)



