### Name: modelOutcome
### Title: Compare regression coefficients across studies
### Aliases: modelOutcome
### Keywords: models

### ** Examples

  if(require(Biobase) & require(MASS) & require(survival)){
  data(mergeData)
  merged  <- mergeExprs(sample1,sample2,sample3)

  log.coeff  <- modelOutcome(merged,outcome=c(1,1,1),method="logistic")
  plot(coeff(log.coeff))
  
  linear.coeff  <- modelOutcome(merged[1:2],outcome=c(3,3),method="linear")
  plot(zscore(linear.coeff),xlab="study 1",ylab="study 2")

  event1<-rbinom(100,1,.5)
  event2<-rbinom(50,1,.5) 
  event3<-rbinom(70,1,.5)

  out1<-rnorm(100,5,1)
  out2<-rnorm(50,5,1)
  out3<-rnorm(70,5,1)

  out<-list(out1,out2,out3)
  even<-list(event1,event2,event3)

  cox.coeff<-modelOutcome(merged,outcome2=even,outcome=out,method="cox")
  plot(coeff(cox.coeff))

  }



