### Name: am.trans
### Title: Transform replicated arrays into (A,M) format
### Aliases: am.trans
### Keywords: methods

### ** Examples

  library(LPE)
  # Loading the LPE library
 
  # Test data with duplicates
  temp1 <- matrix(c(1,20,1.5,23),nrow=2)
  am.trans(temp1)
  # It gives a matrix of (4*2) as only two permutaions
  # are possible for each row with duplicates (X1-X2, and X2-X1)
  
  
  # Another test data with three replicates
  temp2 <- matrix(c(1,20,1.5,23,0.8,19),nrow=2)
  am.trans(temp2)
  # Now it returns matrix of (12*2) as there are
  # 6 possible permutations for each row with triplicates
  # (X1-X2, X1-X3, X2-X3, X2-X1, X3-X1 and X3-X2)
  



