### Name: picketplot
### Title: Barplots for Several Binary Variables
### Aliases: picketplot
### Keywords: hplot aplot

### ** Examples

# without covariate
mm = cbind(sample(0:1, 42, rep=TRUE), sample(0:1, 42, rep=TRUE))
mm[sample(42, 5), 1] = NA
picketplot(mm)

# with clustering
cl = rep(1:3, c(10,22,10))
cn = c("Cluster I","Cluster II","Cluster III")
cc = c("lightblue","lightgreen","lightpink") # windows palette
picketplot(mm, grp=cl, grplabel=cn, grpcol=cc)

# add a covariate; setting the colnames makes the variable labels
mm = cbind(mm, rnorm(42) + cl/2)
colnames(mm) = c("State A","State B", "X")
picketplot(mm, covariate=3,grp=cl, grplabel=cn, grpcol=cc)

# using extra controls
picketplot(mm, covariate=3,grp=cl, grplabel=cn, grpcol=cc, control=list(nacol="white", degree=0))




