### Name: GlobalAncova.decomp
### Title: GlobalAncova with sequential and type III sum of squares
###   decomposition and adjustment for global covariates
### Aliases: GlobalAncova.decomp
### Keywords: models

### ** Examples

data(vantVeer)
data(phenodata)
data(pathways)

# sequential or type III decomposition
GlobalAncova.decomp(xx = vantVeer, formula = ~ grade + metastases + ERstatus, model.dat = phenodata, method = "sequential", test.genes = pathways[1:3])
GlobalAncova.decomp(xx = vantVeer, formula = ~ grade + metastases + ERstatus, model.dat = phenodata, method = "type3", test.genes = pathways[1:3]) 

# adjustment for global covariate
data(colon.tumour)
data(colon.normal)
data(colon.pheno)
GlobalAncova.decomp(xx = colon.tumour, formula = ~ UICC.stage + sex + location, model.dat = colon.pheno, method = "all", zz = colon.normal)



