### Name: snpScreen
### Title: compute model fits over a sequence of SNPs
### Aliases: snpScreenResult-class show,snpScreenResult-method
###   snpScreen,racExSet,snpMeta,genesym,formula,function,numeric-method
###   snpScreen,racExSet,snpMeta,genesym,formula,function,missing-method
###   snpScreen extract_p fastAGM fastHET plot_mlp
### Keywords: models

### ** Examples

example(make_racExSet)
dem
dem = exclMono(dem)
snpNames(dem)[1:4]
featureNames(dem)[1:4]
data(chr20GGdem)
data(chr20meta)
data(geneLocs_hsa)
scr1 = snpScreen(dem, chr20meta, genesym("DDR1"), ~., lm,  gran=100 )
scr1[[1]]
scr2 = snpScreen(dem, chr20meta, genesym("DDR1"), ~factor(.), lm,  gran=200 )
scr2[[1]]
plot_mlp(scr1, chr20meta, geneLocDF=geneLocs_hsa)
chr20GGdem = exclMono(chr20GGdem)
ut = unix.time(scr2 <- snpScreen(chr20GGdem, chr20meta, genesym("CPNE1"), ~factor(.), fastAGM, 50))
ut
scr2
plot_mlp(scr2, chr20meta, geneLocDF=geneLocs_hsa)
#
# here we work on a WebQTL computation
#
# get the expr+genotype data
data(gse2031GG)
# get a provisional snp metadata structure
data(INB34snpMeta)
# run a screen for Erdr1
ss = snpScreen(gse2031GG, INB34snpMeta, genesym("Erdr1"), ~., fastAGM, 1)
plot_mlp(ss, INB34snpMeta, gchr="all", plotf=plot, organism="mouse" )



