### Name: propagate
### Title: Voronoi-based segmentation on image manifolds
### Aliases: propagate
### Keywords: file

### ** Examples

    if ( interactive() ) {
      ddir <- paste( system.file(package="EBImage"), "images", sep="/" )
      a <- read.image( paste(ddir, c("A04w0.jpg", "A04w1.jpg"), sep="/") )
      rgb <- channel(a[,,1],"asred") + channel(a[,,2],"asgreen")

      ## Not run: detecting nuclei by watershed
      t <- thresh( blur(a[,,2], 4, 2), 15, 15)
      t <- opening( closing(t, morphKern(9)) )
      w <- watershed( distmap(t) )

      ## Not run: generating mask for propagate
      mask <- thresh( a[,,1], 50, 50, -0.01)
      mask <- closing( mask, morphKern(13) )
      mask <- opening( mask, morphKern(11) )
      mask <- erode(mask)

      ## Not run: propagate with the mask and gradient-driven metric
      wx <- propagate( a[,,1], w, mask, 0.0001, 2)
      prev <- paintObjects(wx, paintObjects(w, rgb))
      display(prev)

      ## Not run: pure Voronoi: no mask and almost no gradient term in metric
      wx1 <- propagate( a[,,1], w, NULL, 1e8, 2)
      prev1 <- paintObjects(wx1, rgb)
      display(prev1)
    }
  


