### Name: comp.modt
### Title: Computing Moderated t-statistics for Differential Expression
### Aliases: comp.modt
### Keywords: univar

### ** Examples

X <- matrix(rnorm(1000,0,0.5), nc=10)
L <- rep(0:1,c(5,5))

# genes 1-10 are differentially expressed
X[1:10,6:10]<-X[1:10,6:10]+1

tmod <- comp.modt(L)
tmod.X <- tmod(X)

# Another way of computing moderated t statistics
tmod.X <- comp.stat(X, L, "modt")



