### Name: comp.ebayes
### Title: Computing Empirical Bayes Statistics for Differential Expression
### Aliases: comp.ebayes
### Keywords: htest

### ** Examples

X <- matrix(rnorm(1000,0,0.5), nc=10)
L <- rep(0:1,c(5,5))

# genes 1-10 are differentially expressed
X[1:10,6:10]<-X[1:10,6:10]+1

# compute B and moderated t statistics, proportion set as 0.01
ebayes.fun <- comp.ebayes(L)
ebayes.X <- ebayes.fun(X)

# compute B and moderated t statistics, proportion set as 0.1
ebayes.fun <- comp.ebayes(L, proportion=0.1)
ebayes.X <- ebayes.fun(X)




