### Name: mask
### Title: Masking portions of a sequence
### Aliases: mask mask,BString-method mask,character-method
###   mask,BStringViews-method
### Keywords: methods

### ** Examples

  ## masking "by position"
  mask("AxyxyxBC", 2, 6)

  ## masking "by content"
  mask("AxyxyxBC", "xyx")

  ## masking the N's in a chromosome sequence
  library(BSgenome.Dmelanogaster.FlyBase.r51)
  x <- Dmelanogaster[["3L"]]
  alphabetFrequency(x)
  noN_x <- mask(x, "N")
  alphabetFrequency(noN_x)

  ## masking a BStringViews object
  v <- views("AxyxyxBC", c(6, 4,-1, NA), c(7, 6, 1, 1))
  mask(v)

  ## note that applying mask() again returns a BStringViews object
  ## where the original views on v have been merged, sorted from left to right
  ## and cleaned from their "out of limits" portions
  mask(mask(v))

  ## finally, note that mask(mask(mask(v))) is _always_ the same as mask(v)
  mask(mask(mask(v)))



