package com.abien.winery.business.winesearch.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;

/**
 *
 * @author abien-bien.com
 */

@Entity
@NamedQueries({
    @NamedQuery(name=Wine.findWineByName,query="SELECT w FROM Wine w where UPPER(w.name) LIKE :name")
})
public class Wine {

    public final static String PREFIX = "com.abien.winery.business.winesearch.domain";
    public final static String findWineByName = "findWineByName";

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    private String name;

    @Column(name="YR")
    private int year;
    
    private BigDecimal price;

    @ManyToMany(mappedBy = "wines")
    private List<WineCellar> wineCellars;

    private String imageUrl;

    public Wine() {
        this.wineCellars = new ArrayList<WineCellar>();
    }

    public Wine(String name, String imageUrl, int year, double price) {
        this();
        this.name = name;
        this.year = year;
        this.imageUrl = imageUrl;
        this.price = new BigDecimal(price);
    }

    public Wine add(WineCellar wine){
        this.wineCellars.add(wine);
        return this;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public int getAge(){
        return GregorianCalendar.getInstance().get(GregorianCalendar.YEAR) - this.year;
    }


}
