/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.jsfcl.data;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.CachedRowSetDataProvider;
import java.beans.Beans;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.model.DataModel;
import javax.sql.rowset.CachedRowSet;

public class CachedRowSetWrapperDataModel
extends DataModel {
    private static Logger log = Logger.getLogger("com.icesoft.faces.component.jsfcl.data.CachedRowSetWrapperDataModel");
    private CachedRowSet cachedRowSet;
    private TreeMap[] rows = null;
    private int index = -1;

    public CachedRowSetWrapperDataModel() {
        this(null);
    }

    public CachedRowSetWrapperDataModel(CachedRowSet cachedRowSet) {
        this.setWrappedData(cachedRowSet);
    }

    public boolean isRowAvailable() {
        if (this.cachedRowSet == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.rows.length;
    }

    public int getRowCount() {
        if (this.cachedRowSet == null) {
            return -1;
        }
        return this.rows.length;
    }

    public Object getRowData() {
        if (this.cachedRowSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            if (!Beans.isDesignTime()) {
                throw new IllegalArgumentException();
            }
            return null;
        }
        return this.rows[this.index];
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        this.index = rowIndex;
        if (this.cachedRowSet == null) {
            return;
        }
    }

    public Object getWrappedData() {
        return this.rows;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.cachedRowSet = null;
            this.rows = null;
            this.setRowIndex(-1);
        } else if (data instanceof CachedRowSet) {
            this.cachedRowSet = (CachedRowSet)data;
            this.rows = this.initDataCache();
        } else {
            log.log(Level.FINEST, "wrong data = " + data.getClass().getName());
            throw new IllegalArgumentException();
        }
    }

    private TreeMap[] initDataCache() {
        CachedRowSetDataProvider tableDataProvider = new CachedRowSetDataProvider(this.cachedRowSet);
        if (tableDataProvider.getRowCount() != -1) {
            FieldKey[] fieldKeys = tableDataProvider.getFieldKeys();
            for (int j = 0; j < fieldKeys.length; ++j) {
                String val = fieldKeys[j].getFieldId();
                int loc = val.lastIndexOf(46);
                if (loc >= 0 && loc + 1 < val.length()) {
                    val = val.substring(loc + 1);
                }
                fieldKeys[j].setDisplayName(val);
                log.log(Level.FINEST, "field key=" + fieldKeys[j].getDisplayName() + "field id=" + fieldKeys[j].getFieldId());
            }
            RowKey[] rowKeys = tableDataProvider.getRowKeys(Integer.MAX_VALUE, null);
            this.rows = new TreeMap[rowKeys.length];
            for (int j = 0; j < rowKeys.length; ++j) {
                TreeMap<String, Object> row = new TreeMap<String, Object>();
                for (int i = 0; i < fieldKeys.length; ++i) {
                    row.put(fieldKeys[i].getDisplayName(), tableDataProvider.getValue(fieldKeys[i], rowKeys[j]));
                }
                this.rows[j] = row;
            }
        } else {
            log.log(Level.FINEST, " RowSet has no data" + tableDataProvider.getRowCount());
        }
        log.log(Level.FINEST, "dataCached rows=" + this.rows.length);
        return this.rows;
    }
}

