/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util;

import edu.emory.mathcs.backport.java.util.AbstractMap;
import edu.emory.mathcs.backport.java.util.NavigableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class TreeMap
extends AbstractMap
implements NavigableMap,
Cloneable,
Serializable {
    volatile transient Set keySet = null;
    volatile transient Collection values = null;
    private Comparator comparator = null;
    private transient Entry root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient Set entrySet = null;
    private transient Set descendingEntrySet = null;
    private transient Set descendingKeySet = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public TreeMap() {
    }

    public TreeMap(Comparator comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map m) {
        this.putAll(m);
    }

    public TreeMap(SortedMap m) {
        this.comparator = m.comparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.root == null ? false : (value == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, value));
    }

    private boolean valueSearchNull(Entry n) {
        if (n.value == null) {
            return true;
        }
        return n.left != null && this.valueSearchNull(n.left) || n.right != null && this.valueSearchNull(n.right);
    }

    private boolean valueSearchNonNull(Entry n, Object value) {
        if (value.equals(n.value)) {
            return true;
        }
        return n.left != null && this.valueSearchNonNull(n.left, value) || n.right != null && this.valueSearchNonNull(n.right, value);
    }

    public Object get(Object key) {
        Entry p = this.getEntry(key);
        return p == null ? null : p.value;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public Object firstKey() {
        return TreeMap.key(this.getFirstEntry());
    }

    public Object lastKey() {
        return TreeMap.key(this.getLastEntry());
    }

    public void putAll(Map map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && ((Object)c).equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException cannotHappen) {
            }
            catch (ClassNotFoundException cannotHappen) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    private Entry getEntry(Object key) {
        if (this.comparator != null) {
            return this.getEntryUsingComparator(key);
        }
        Comparable k = (Comparable)key;
        Entry p = this.root;
        while (p != null) {
            int cmp = k.compareTo(p.key);
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            if (cmp > 0) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    private Entry getEntryUsingComparator(Object key) {
        Object k = key;
        Comparator cpr = this.comparator;
        Entry p = this.root;
        while (p != null) {
            int cmp = cpr.compare(k, p.key);
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            if (cmp > 0) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    private Entry getCeilingEntry(Object key) {
        Entry p;
        block5: {
            p = this.root;
            if (p == null) {
                return null;
            }
            while (true) {
                int cmp;
                if ((cmp = this.compare(key, p.key)) < 0) {
                    if (p.left != null) {
                        p = p.left;
                        continue;
                    }
                    return p;
                }
                if (cmp <= 0) break block5;
                if (p.right == null) break;
                p = p.right;
            }
            Entry parent = p.parent;
            Entry ch = p;
            while (parent != null && ch == parent.right) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return p;
    }

    private Entry getFloorEntry(Object key) {
        Entry p;
        block5: {
            p = this.root;
            if (p == null) {
                return null;
            }
            while (true) {
                int cmp;
                if ((cmp = this.compare(key, p.key)) > 0) {
                    if (p.right != null) {
                        p = p.right;
                        continue;
                    }
                    return p;
                }
                if (cmp >= 0) break block5;
                if (p.left == null) break;
                p = p.left;
            }
            Entry parent = p.parent;
            Entry ch = p;
            while (parent != null && ch == parent.left) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return p;
    }

    private Entry getHigherEntry(Object key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right == null) break;
            p = p.right;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.right) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Entry getLowerEntry(Object key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left == null) break;
            p = p.left;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.left) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static Object key(Entry e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    public Object put(Object key, Object value) {
        Entry t = this.root;
        if (t == null) {
            if (key == null) {
                if (this.comparator == null) {
                    throw new NullPointerException();
                }
                this.comparator.compare(key, key);
            }
            this.incrementSize();
            this.root = new Entry(key, value, null);
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, t.key)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                this.incrementSize();
                t.left = new Entry(key, value, t);
                this.fixAfterInsertion(t.left);
                return null;
            }
            if (t.right == null) break;
            t = t.right;
        }
        this.incrementSize();
        t.right = new Entry(key, value, t);
        this.fixAfterInsertion(t.right);
        return null;
    }

    public Object remove(Object key) {
        Entry p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    public Object clone() {
        TreeMap clone = null;
        try {
            clone = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        clone.entrySet = null;
        clone.descendingEntrySet = null;
        clone.descendingKeySet = null;
        try {
            clone.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    public Map.Entry firstEntry() {
        Entry e = this.getFirstEntry();
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Map.Entry lastEntry() {
        Entry e = this.getLastEntry();
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Map.Entry pollFirstEntry() {
        Entry p = this.getFirstEntry();
        if (p == null) {
            return null;
        }
        AbstractMap.SimpleImmutableEntry result = new AbstractMap.SimpleImmutableEntry(p);
        this.deleteEntry(p);
        return result;
    }

    public Map.Entry pollLastEntry() {
        Entry p = this.getLastEntry();
        if (p == null) {
            return null;
        }
        AbstractMap.SimpleImmutableEntry result = new AbstractMap.SimpleImmutableEntry(p);
        this.deleteEntry(p);
        return result;
    }

    public Map.Entry lowerEntry(Object key) {
        Entry e = this.getLowerEntry(key);
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Object lowerKey(Object key) {
        Entry e = this.getLowerEntry(key);
        return e == null ? null : e.key;
    }

    public Map.Entry floorEntry(Object key) {
        Entry e = this.getFloorEntry(key);
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Object floorKey(Object key) {
        Entry e = this.getFloorEntry(key);
        return e == null ? null : e.key;
    }

    public Map.Entry ceilingEntry(Object key) {
        Entry e = this.getCeilingEntry(key);
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Object ceilingKey(Object key) {
        Entry e = this.getCeilingEntry(key);
        return e == null ? null : e.key;
    }

    public Map.Entry higherEntry(Object key) {
        Entry e = this.getHigherEntry(key);
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Object higherKey(Object key) {
        Entry e = this.getHigherEntry(key);
        return e == null ? null : e.key;
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Set descendingEntrySet() {
        Set es = this.descendingEntrySet;
        return es != null ? es : (this.descendingEntrySet = new DescendingEntrySet());
    }

    public Set descendingKeySet() {
        Set ks = this.descendingKeySet;
        return ks != null ? ks : (this.descendingKeySet = new DescendingKeySet());
    }

    public NavigableMap navigableSubMap(Object fromKey, Object toKey) {
        return new SubMap(fromKey, toKey);
    }

    public NavigableMap navigableHeadMap(Object toKey) {
        return new SubMap(toKey, true);
    }

    public NavigableMap navigableTailMap(Object fromKey) {
        return new SubMap(fromKey, false);
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        return new SubMap(fromKey, toKey);
    }

    public SortedMap headMap(Object toKey) {
        return new SubMap(toKey, true);
    }

    public SortedMap tailMap(Object fromKey) {
        return new SubMap(fromKey, false);
    }

    private int compare(Object k1, Object k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private Entry getFirstEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    private Entry getLastEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    private Entry successor(Entry t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private Entry predecessor(Entry t) {
        if (t == null) {
            return null;
        }
        if (t.left != null) {
            Entry p = t.left;
            while (p.right != null) {
                p = p.right;
            }
            return p;
        }
        Entry p = t.parent;
        Entry ch = t;
        while (p != null && ch == p.left) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static boolean colorOf(Entry p) {
        return p == null ? true : p.color;
    }

    private static Entry parentOf(Entry p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(Entry p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static Entry leftOf(Entry p) {
        return p == null ? null : p.left;
    }

    private static Entry rightOf(Entry p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(Entry p) {
        Entry r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(Entry p) {
        Entry l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void fixAfterInsertion(Entry x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry y;
            if (TreeMap.parentOf(x) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(x)))) {
                y = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(x)));
                if (!TreeMap.colorOf(y)) {
                    TreeMap.setColor(TreeMap.parentOf(x), true);
                    TreeMap.setColor(y, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                    x = TreeMap.parentOf(TreeMap.parentOf(x));
                    continue;
                }
                if (x == TreeMap.rightOf(TreeMap.parentOf(x))) {
                    x = TreeMap.parentOf(x);
                    this.rotateLeft(x);
                }
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                if (TreeMap.parentOf(TreeMap.parentOf(x)) == null) continue;
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(x)));
                continue;
            }
            y = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(x)));
            if (!TreeMap.colorOf(y)) {
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(y, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                x = TreeMap.parentOf(TreeMap.parentOf(x));
                continue;
            }
            if (x == TreeMap.leftOf(TreeMap.parentOf(x))) {
                x = TreeMap.parentOf(x);
                this.rotateRight(x);
            }
            TreeMap.setColor(TreeMap.parentOf(x), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
            if (TreeMap.parentOf(TreeMap.parentOf(x)) == null) continue;
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry p) {
        Entry replacement;
        this.decrementSize();
        if (p.left != null && p.right != null) {
            Entry s = this.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry x) {
        while (x != this.root && TreeMap.colorOf(x)) {
            Entry sib;
            if (x == TreeMap.leftOf(TreeMap.parentOf(x))) {
                sib = TreeMap.rightOf(TreeMap.parentOf(x));
                if (!TreeMap.colorOf(sib)) {
                    TreeMap.setColor(sib, true);
                    TreeMap.setColor(TreeMap.parentOf(x), false);
                    this.rotateLeft(TreeMap.parentOf(x));
                    sib = TreeMap.rightOf(TreeMap.parentOf(x));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(sib)) && TreeMap.colorOf(TreeMap.rightOf(sib))) {
                    TreeMap.setColor(sib, false);
                    x = TreeMap.parentOf(x);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(sib))) {
                    TreeMap.setColor(TreeMap.leftOf(sib), true);
                    TreeMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = TreeMap.rightOf(TreeMap.parentOf(x));
                }
                TreeMap.setColor(sib, TreeMap.colorOf(TreeMap.parentOf(x)));
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(TreeMap.rightOf(sib), true);
                this.rotateLeft(TreeMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = TreeMap.leftOf(TreeMap.parentOf(x));
            if (!TreeMap.colorOf(sib)) {
                TreeMap.setColor(sib, true);
                TreeMap.setColor(TreeMap.parentOf(x), false);
                this.rotateRight(TreeMap.parentOf(x));
                sib = TreeMap.leftOf(TreeMap.parentOf(x));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(sib)) && TreeMap.colorOf(TreeMap.leftOf(sib))) {
                TreeMap.setColor(sib, false);
                x = TreeMap.parentOf(x);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(sib))) {
                TreeMap.setColor(TreeMap.rightOf(sib), true);
                TreeMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = TreeMap.leftOf(TreeMap.parentOf(x));
            }
            TreeMap.setColor(sib, TreeMap.colorOf(TreeMap.parentOf(x)));
            TreeMap.setColor(TreeMap.parentOf(x), true);
            TreeMap.setColor(TreeMap.leftOf(sib), true);
            this.rotateRight(TreeMap.parentOf(x));
            x = this.root;
        }
        TreeMap.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    void readTreeSet(int size, ObjectInputStream s, Object defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    void addAllForTreeSet(SortedSet set, Object defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int size, Iterator it, ObjectInputStream str, Object defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = this.buildFromSorted(0, 0, size - 1, TreeMap.computeRedLevel(size), it, str, defaultVal);
    }

    private final Entry buildFromSorted(int level, int lo, int hi, int redLevel, Iterator it, ObjectInputStream str, Object defaultVal) throws IOException, ClassNotFoundException {
        Object value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        Entry left = null;
        if (lo < mid) {
            left = this.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        Entry middle = new Entry(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            Entry right;
            middle.right = right = this.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    static class Entry
    implements Map.Entry {
        Object key;
        Object value;
        Entry left = null;
        Entry right = null;
        Entry parent;
        boolean color = true;

        Entry(Object key, Object value, Entry parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return TreeMap.valEquals(this.key, e.getKey()) && TreeMap.valEquals(this.value, e.getValue());
        }

        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    class DescendingSubMapEntryIterator
    extends DescendingPrivateEntryIterator {
        private final Object lastExcludedKey;

        DescendingSubMapEntryIterator(Entry last, Entry lastExcluded) {
            super(last);
            this.lastExcludedKey = lastExcluded == null ? null : lastExcluded.key;
        }

        public boolean hasNext() {
            return this.next != null && this.next.key != this.lastExcludedKey;
        }

        public Object next() {
            if (this.next == null || this.next.key == this.lastExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    class DescendingKeyIterator
    extends DescendingPrivateEntryIterator {
        DescendingKeyIterator(Entry first) {
            super(first);
        }

        public Object next() {
            return this.nextEntry().key;
        }
    }

    class DescendingEntryIterator
    extends DescendingPrivateEntryIterator {
        DescendingEntryIterator(Entry first) {
            super(first);
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    abstract class DescendingPrivateEntryIterator
    extends PrivateEntryIterator {
        DescendingPrivateEntryIterator(Entry first) {
            super(first);
        }

        Entry nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = TreeMap.this.predecessor(this.next);
            return this.lastReturned;
        }
    }

    class SubMapEntryIterator
    extends PrivateEntryIterator {
        private final Object firstExcludedKey;

        SubMapEntryIterator(Entry first, Entry firstExcluded) {
            super(first);
            this.firstExcludedKey = firstExcluded == null ? null : firstExcluded.key;
        }

        public boolean hasNext() {
            return this.next != null && this.next.key != this.firstExcludedKey;
        }

        public Object next() {
            if (this.next == null || this.next.key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    class ValueIterator
    extends PrivateEntryIterator {
        ValueIterator(Entry first) {
            super(first);
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    class KeyIterator
    extends PrivateEntryIterator {
        KeyIterator(Entry first) {
            super(first);
        }

        public Object next() {
            return this.nextEntry().key;
        }
    }

    class EntryIterator
    extends PrivateEntryIterator {
        EntryIterator(Entry first) {
            super(first);
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    abstract class PrivateEntryIterator
    implements Iterator {
        int expectedModCount;
        Entry lastReturned;
        Entry next;

        PrivateEntryIterator(Entry first) {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = TreeMap.this.successor(this.next);
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    private class SubMap
    extends AbstractMap
    implements NavigableMap,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart = false;
        private boolean toEnd = false;
        private Object fromKey;
        private Object toKey;
        private transient Set entrySet = null;
        private transient Set descendingEntrySetView = null;
        private transient Set descendingKeySetView = null;

        SubMap(Object fromKey, Object toKey) {
            if (TreeMap.this.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        SubMap(Object key, boolean headMap) {
            TreeMap.this.compare(key, key);
            if (headMap) {
                this.fromStart = true;
                this.toKey = key;
            } else {
                this.toEnd = true;
                this.fromKey = key;
            }
        }

        SubMap(boolean fromStart, Object fromKey, boolean toEnd, Object toKey) {
            this.fromStart = fromStart;
            this.fromKey = fromKey;
            this.toEnd = toEnd;
            this.toKey = toKey;
        }

        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.inRange(key) && TreeMap.this.containsKey(key);
        }

        public Object get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return TreeMap.this.get(key);
        }

        public Object put(Object key, Object value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return TreeMap.this.put(key, value);
        }

        public Object remove(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return TreeMap.this.remove(key);
        }

        public Comparator comparator() {
            return TreeMap.this.comparator;
        }

        public Object firstKey() {
            Entry e = this.fromStart ? TreeMap.this.getFirstEntry() : TreeMap.this.getCeilingEntry(this.fromKey);
            Object first = TreeMap.key(e);
            if (!this.toEnd && TreeMap.this.compare(first, this.toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return first;
        }

        public Object lastKey() {
            Entry e = this.toEnd ? TreeMap.this.getLastEntry() : TreeMap.this.getLowerEntry(this.toKey);
            Object last = TreeMap.key(e);
            if (!this.fromStart && TreeMap.this.compare(last, this.fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return last;
        }

        public Map.Entry firstEntry() {
            Entry e;
            Entry entry = e = this.fromStart ? TreeMap.this.getFirstEntry() : TreeMap.this.getCeilingEntry(this.fromKey);
            if (e == null || !this.toEnd && TreeMap.this.compare(e.key, this.toKey) >= 0) {
                return null;
            }
            return e;
        }

        public Map.Entry lastEntry() {
            Entry e;
            Entry entry = e = this.toEnd ? TreeMap.this.getLastEntry() : TreeMap.this.getLowerEntry(this.toKey);
            if (e == null || !this.fromStart && TreeMap.this.compare(e.key, this.fromKey) < 0) {
                return null;
            }
            return e;
        }

        public Map.Entry pollFirstEntry() {
            Entry e;
            Entry entry = e = this.fromStart ? TreeMap.this.getFirstEntry() : TreeMap.this.getCeilingEntry(this.fromKey);
            if (e == null || !this.toEnd && TreeMap.this.compare(e.key, this.toKey) >= 0) {
                return null;
            }
            AbstractMap.SimpleImmutableEntry result = new AbstractMap.SimpleImmutableEntry(e);
            TreeMap.this.deleteEntry(e);
            return result;
        }

        public Map.Entry pollLastEntry() {
            Entry e;
            Entry entry = e = this.toEnd ? TreeMap.this.getLastEntry() : TreeMap.this.getLowerEntry(this.toKey);
            if (e == null || !this.fromStart && TreeMap.this.compare(e.key, this.fromKey) < 0) {
                return null;
            }
            AbstractMap.SimpleImmutableEntry result = new AbstractMap.SimpleImmutableEntry(e);
            TreeMap.this.deleteEntry(e);
            return result;
        }

        private Entry subceiling(Object key) {
            Entry e;
            Entry entry = e = !this.fromStart && TreeMap.this.compare(key, this.fromKey) < 0 ? TreeMap.this.getCeilingEntry(this.fromKey) : TreeMap.this.getCeilingEntry(key);
            if (e == null || !this.toEnd && TreeMap.this.compare(e.key, this.toKey) >= 0) {
                return null;
            }
            return e;
        }

        public Map.Entry ceilingEntry(Object key) {
            Entry e = this.subceiling(key);
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object ceilingKey(Object key) {
            Entry e = this.subceiling(key);
            return e == null ? null : e.key;
        }

        private Entry subhigher(Object key) {
            Entry e;
            Entry entry = e = !this.fromStart && TreeMap.this.compare(key, this.fromKey) < 0 ? TreeMap.this.getCeilingEntry(this.fromKey) : TreeMap.this.getHigherEntry(key);
            if (e == null || !this.toEnd && TreeMap.this.compare(e.key, this.toKey) >= 0) {
                return null;
            }
            return e;
        }

        public Map.Entry higherEntry(Object key) {
            Entry e = this.subhigher(key);
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object higherKey(Object key) {
            Entry e = this.subhigher(key);
            return e == null ? null : e.key;
        }

        private Entry subfloor(Object key) {
            Entry e;
            Entry entry = e = !this.toEnd && TreeMap.this.compare(key, this.toKey) >= 0 ? TreeMap.this.getLowerEntry(this.toKey) : TreeMap.this.getFloorEntry(key);
            if (e == null || !this.fromStart && TreeMap.this.compare(e.key, this.fromKey) < 0) {
                return null;
            }
            return e;
        }

        public Map.Entry floorEntry(Object key) {
            Entry e = this.subfloor(key);
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object floorKey(Object key) {
            Entry e = this.subfloor(key);
            return e == null ? null : e.key;
        }

        private Entry sublower(Object key) {
            Entry e;
            Entry entry = e = !this.toEnd && TreeMap.this.compare(key, this.toKey) >= 0 ? TreeMap.this.getLowerEntry(this.toKey) : TreeMap.this.getLowerEntry(key);
            if (e == null || !this.fromStart && TreeMap.this.compare(e.key, this.fromKey) < 0) {
                return null;
            }
            return e;
        }

        public Map.Entry lowerEntry(Object key) {
            Entry e = this.sublower(key);
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object lowerKey(Object key) {
            Entry e = this.sublower(key);
            return e == null ? null : e.key;
        }

        public Set entrySet() {
            Set es = this.entrySet;
            return es != null ? es : (this.entrySet = new EntrySetView());
        }

        public Set descendingEntrySet() {
            Set es = this.descendingEntrySetView;
            return es != null ? es : (this.descendingEntrySetView = new DescendingEntrySetView());
        }

        public Set descendingKeySet() {
            Set ks = this.descendingKeySetView;
            return ks != null ? ks : (this.descendingKeySetView = new DescendingKeySetView());
        }

        public NavigableMap navigableSubMap(Object fromKey, Object toKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(fromKey, toKey);
        }

        public NavigableMap navigableHeadMap(Object toKey) {
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromStart, this.fromKey, false, toKey);
        }

        public NavigableMap navigableTailMap(Object fromKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(false, fromKey, this.toEnd, this.toKey);
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return this.navigableSubMap(fromKey, toKey);
        }

        public SortedMap headMap(Object toKey) {
            return this.navigableHeadMap(toKey);
        }

        public SortedMap tailMap(Object fromKey) {
            return this.navigableTailMap(fromKey);
        }

        private boolean inRange(Object key) {
            return !(!this.fromStart && TreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && TreeMap.this.compare(key, this.toKey) >= 0);
        }

        private boolean inRange2(Object key) {
            return !(!this.fromStart && TreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && TreeMap.this.compare(key, this.toKey) > 0);
        }

        private class DescendingKeySetView
        extends AbstractSet {
            private DescendingKeySetView() {
            }

            public Iterator iterator() {
                return new Iterator(this){
                    private Iterator i;
                    private final /* synthetic */ DescendingKeySetView this$2;
                    {
                        this.this$2 = this$2;
                        this.i = DescendingKeySetView.access$2400(this.this$2).descendingEntrySet().iterator();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public Object next() {
                        return ((Map.Entry)this.i.next()).getKey();
                    }

                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            public int size() {
                return SubMap.this.size();
            }

            public boolean contains(Object k) {
                return SubMap.this.containsKey(k);
            }

            static /* synthetic */ SubMap access$2400(DescendingKeySetView x0) {
                return x0.SubMap.this;
            }
        }

        private class DescendingEntrySetView
        extends EntrySetView {
            private DescendingEntrySetView() {
            }

            public Iterator iterator() {
                return new DescendingSubMapEntryIterator(SubMap.this.toEnd ? TreeMap.this.getLastEntry() : TreeMap.this.getLowerEntry(SubMap.this.toKey), SubMap.this.fromStart ? null : TreeMap.this.getLowerEntry(SubMap.this.fromKey));
            }
        }

        private class EntrySetView
        extends AbstractSet {
            private transient int size = -1;
            private transient int sizeModCount;

            private EntrySetView() {
            }

            public int size() {
                if (this.size == -1 || this.sizeModCount != TreeMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = TreeMap.this.modCount;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = TreeMap.this.getEntry(key);
                return node != null && TreeMap.valEquals(node.getValue(), entry.getValue());
            }

            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = TreeMap.this.getEntry(key);
                if (node != null && TreeMap.valEquals(node.getValue(), entry.getValue())) {
                    TreeMap.this.deleteEntry(node);
                    return true;
                }
                return false;
            }

            public Iterator iterator() {
                return new SubMapEntryIterator(SubMap.this.fromStart ? TreeMap.this.getFirstEntry() : TreeMap.this.getCeilingEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : TreeMap.this.getCeilingEntry(SubMap.this.toKey));
            }
        }
    }

    class DescendingKeySet
    extends KeySet {
        DescendingKeySet() {
        }

        public Iterator iterator() {
            return new DescendingKeyIterator(TreeMap.this.getLastEntry());
        }
    }

    class DescendingEntrySet
    extends EntrySet {
        DescendingEntrySet() {
        }

        public Iterator iterator() {
            return new DescendingEntryIterator(TreeMap.this.getLastEntry());
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator(TreeMap.this.getFirstEntry());
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Entry p = TreeMap.this.getEntry(entry.getKey());
            return p != null && TreeMap.valEquals(p.getValue(), value);
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Entry p = TreeMap.this.getEntry(entry.getKey());
            if (p != null && TreeMap.valEquals(p.getValue(), value)) {
                TreeMap.this.deleteEntry(p);
                return true;
            }
            return false;
        }

        public int size() {
            return TreeMap.this.size();
        }

        public void clear() {
            TreeMap.this.clear();
        }
    }

    class Values
    extends AbstractCollection {
        Values() {
        }

        public Iterator iterator() {
            return new ValueIterator(TreeMap.this.getFirstEntry());
        }

        public int size() {
            return TreeMap.this.size();
        }

        public boolean contains(Object o) {
            Entry e = TreeMap.this.getFirstEntry();
            while (e != null) {
                if (TreeMap.valEquals(e.getValue(), o)) {
                    return true;
                }
                e = TreeMap.this.successor(e);
            }
            return false;
        }

        public boolean remove(Object o) {
            Entry e = TreeMap.this.getFirstEntry();
            while (e != null) {
                if (TreeMap.valEquals(e.getValue(), o)) {
                    TreeMap.this.deleteEntry(e);
                    return true;
                }
                e = TreeMap.this.successor(e);
            }
            return false;
        }

        public void clear() {
            TreeMap.this.clear();
        }
    }

    class KeySet
    extends AbstractSet {
        KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator(TreeMap.this.getFirstEntry());
        }

        public int size() {
            return TreeMap.this.size();
        }

        public boolean contains(Object o) {
            return TreeMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            int oldSize = TreeMap.this.size;
            TreeMap.this.remove(o);
            return TreeMap.this.size != oldSize;
        }

        public void clear() {
            TreeMap.this.clear();
        }
    }
}

