/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.panelpopup;

import com.icesoft.faces.component.ext.renderkit.GroupRenderer;
import com.icesoft.faces.component.panelpopup.PanelPopup;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.context.effects.LocalEffectEncoder;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.CoreUtils;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PanelPopupRenderer
extends GroupRenderer {
    private static Log log = LogFactory.getLog((Class)PanelPopupRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, PanelPopup.class);
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        String headerClass = (String)uiComponent.getAttributes().get("headerClass");
        String bodyClass = (String)uiComponent.getAttributes().get("bodyClass");
        Boolean resizable = null;
        Boolean modal = (Boolean)uiComponent.getAttributes().get("modal");
        if (log.isTraceEnabled()) {
            log.trace((Object)("Value of modal is [" + modal + "]"));
        }
        Boolean visible = (Boolean)uiComponent.getAttributes().get("visible");
        String dndType = this.getDndType(uiComponent);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        PanelPopup panelPopup = (PanelPopup)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        if (!domContext.isInitialized()) {
            String script;
            Element rootDiv = domContext.createRootElement("div");
            PanelPopupRenderer.setRootElementId((FacesContext)facesContext, (Element)rootDiv, (UIComponent)uiComponent);
            rootDiv.setAttribute("name", clientId);
            Element table = domContext.createElement("table");
            table.setAttribute("cellpadding", "0");
            table.setAttribute("cellspacing", "0");
            table.setAttribute("width", "100%");
            rootDiv.appendChild(table);
            if (dndType != null) {
                Element statusField = this.createHiddenField(domContext, facesContext, uiComponent, "status");
                rootDiv.appendChild(statusField);
                Element targetID = this.createHiddenField(domContext, facesContext, uiComponent, "dropID");
                rootDiv.appendChild(targetID);
            }
            if ((script = this.modalJavascript(modal, visible, facesContext, clientId)) != null) {
                Element scriptEle = domContext.createElement("script");
                scriptEle.setAttribute("language", "JavaScript");
                scriptEle.setAttribute("type", "text/javascript");
                Text node = domContext.createTextNode(script);
                scriptEle.appendChild(node);
                rootDiv.appendChild(scriptEle);
            }
        }
        Element root = (Element)domContext.getRootNode();
        try {
            root.setAttribute("class", styleClass);
        }
        catch (Exception e) {
            log.error((Object)"Error rendering Modal Panel Popup ", (Throwable)e);
        }
        JavascriptContext.fireEffect((UIComponent)uiComponent, (FacesContext)facesContext);
        LocalEffectEncoder.encodeLocalEffects((UIComponent)uiComponent, (Element)root, (FacesContext)facesContext);
        NodeList tables = root.getElementsByTagName("table");
        Element table = (Element)tables.item(0);
        DOMContext.removeChildrenByTagName((Element)table, (String)"tr");
        PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, null);
        String handleId = null;
        if (panelPopup.getHeader() != null) {
            Element headerTr = domContext.createElement("tr");
            Element headerTd = domContext.createElement("td");
            headerTd.setAttribute("class", headerClass);
            handleId = uiComponent.getClientId(facesContext) + "Handle";
            headerTd.setAttribute("id", handleId);
            headerTr.appendChild(headerTd);
            table.appendChild(headerTr);
            domContext.setCursorParent((Node)headerTd);
            UIComponent header = panelPopup.getHeader();
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)headerTd);
            CustomComponentUtils.renderChild(facesContext, header);
        }
        if (panelPopup.getBody() != null) {
            Element bodyTr = domContext.createElement("tr");
            Element bodyTd = domContext.createElement("td");
            bodyTd.setAttribute("class", bodyClass);
            bodyTr.setAttribute("id", clientId + "-tr");
            bodyTr.appendChild(bodyTd);
            table.appendChild(bodyTr);
            domContext.setCursorParent((Node)bodyTd);
            UIComponent body = panelPopup.getBody();
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)bodyTd);
            CustomComponentUtils.renderChild(facesContext, body);
        }
        if (resizable != null && resizable.booleanValue()) {
            Element footerTr = domContext.createElement("tr");
            footerTr.setAttribute("height", "15px");
            footerTr.setAttribute("style", "text-align: right; float: right;");
            Element footerTd = domContext.createElement("td");
            footerTd.setAttribute("styleClass", "panelPopupFooter");
            Element img = domContext.createElement("img");
            img.setAttribute("src", CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)"/xmlhttp/css/xp/css-images/resize.gif"));
            img.setAttribute("style", "cursor: se-resize");
            footerTd.appendChild(img);
            footerTr.appendChild(footerTd);
            table.appendChild(footerTr);
        }
        panelPopup.applyStyle(facesContext, root);
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
        if (dndType != null) {
            String call = this.addJavascriptCalls(uiComponent, "DRAG", handleId, facesContext);
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)call);
            if (panelPopup.isClientOnly()) {
                Element clientOnly = domContext.createElement("input");
                clientOnly.setAttribute("type", "hidden");
                clientOnly.setAttribute("id", clientId + "clientOnly");
                root.appendChild(clientOnly);
            }
        }
        String autoPositionJS = null;
        if (panelPopup.getAutoPosition() != null) {
            String positions = panelPopup.getAutoPosition();
            if (positions.indexOf(44) < 1) {
                log.warn((Object)"The autoPosition attribute should be used with an  x and y value for the position, such as '20,40'");
            } else {
                String x = positions.substring(0, positions.indexOf(44));
                String y = positions.substring(positions.indexOf(44) + 1);
                autoPositionJS = "Ice.autoPosition.start('" + clientId + "'," + x + "," + y + ");";
            }
        } else {
            autoPositionJS = "Ice.autoPosition.stop('" + clientId + "');";
        }
        JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)autoPositionJS);
        boolean autoCentre = panelPopup.isAutoCentre();
        String centreJS = autoCentre ? "Ice.autoCentre.start('" + clientId + "');" : "Ice.autoCentre.stop('" + clientId + "');";
        JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)centreJS);
        JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("Ice.iFrameFix.start('" + clientId + "','" + CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)"/xmlhttp/blank") + "');"));
    }

    private String modalJavascript(Boolean modal, Boolean visible, FacesContext facesContext, String clientId) {
        String call = null;
        String iframeUrl = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)"/xmlhttp/blank");
        if (modal != null) {
            if (modal.booleanValue() && visible.booleanValue()) {
                call = "Ice.modal.start('" + clientId + "', '" + iframeUrl + "');";
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Starting Modal Function");
                }
            } else {
                call = "Ice.modal.stop('" + clientId + "');";
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Stopping modal function");
                }
            }
        }
        return call;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Encode End Called");
        }
    }
}

