/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.disk;

import java.io.File;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.FileCleaner;
import org.apache.commons.io.FileCleaningTracker;

public class DiskFileItemFactory
implements FileItemFactory {
    public static final int DEFAULT_SIZE_THRESHOLD = 10240;
    private File repository;
    private int sizeThreshold = 10240;
    private FileCleaningTracker fileCleaningTracker;

    public DiskFileItemFactory() {
        this(FileCleaner.getInstance(), 10240, null);
    }

    public DiskFileItemFactory(int sizeThreshold, File repository) {
        this(FileCleaner.getInstance(), sizeThreshold, repository);
    }

    public DiskFileItemFactory(FileCleaningTracker tracker, int sizeThreshold, File repository) {
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
        this.fileCleaningTracker = tracker;
    }

    public File getRepository() {
        return this.repository;
    }

    public void setRepository(File repository) {
        this.repository = repository;
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        return new DiskFileItem(this, fieldName, contentType, isFormField, fileName);
    }

    public FileCleaningTracker getFileCleaningTracker() {
        return this.fileCleaningTracker;
    }

    public void setFileCleaningTracker(FileCleaningTracker pTracker) {
        this.fileCleaningTracker = pTracker;
    }
}

