/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputconnectionstatus;

import com.icesoft.faces.component.outputconnectionstatus.OutputConnectionStatus;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.util.DOMUtils;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OutputConnectionStatusRenderer
extends DomBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent uiComponent) throws IOException {
        this.validateParameters(context, uiComponent, null);
        OutputConnectionStatus component = (OutputConnectionStatus)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)context, (UIComponent)uiComponent);
        if (!domContext.isInitialized()) {
            String id = uiComponent.getClientId(context);
            Element root = domContext.createRootElement("div");
            domContext.setRootNode((Node)root);
            root.setAttribute("id", id);
            root.setAttribute("class", component.getStyleClass());
            String style = component.getStyle();
            if (style != null && style.length() > 0) {
                root.setAttribute("style", style);
            } else {
                root.removeAttribute("style");
            }
            String idleID = id + ":connection-idle";
            root.appendChild(this.getNextNode(domContext, component.getInactiveClass(), component.getInactiveLabel(), idleID, true));
            String workingID = id + ":connection-working";
            root.appendChild(this.getNextNode(domContext, component.getActiveClass(), component.getActiveLabel(), workingID, false));
            String troubleID = id + ":connection-trouble";
            root.appendChild(this.getNextNode(domContext, component.getCautionClass(), component.getCautionLabel(), troubleID, false));
            String lostID = id + ":connection-lost";
            root.appendChild(this.getNextNode(domContext, component.getDisconnectedClass(), component.getDisconnectedLabel(), lostID, false));
            Element script = domContext.createElement("script");
            script.setAttribute("type", "text/javascript");
            script.appendChild(domContext.createTextNode("'" + id + "'.asExtendedElement().findContainerFor('bridge').bridge.attachStatusManager(" + "function(defaultStatusManager) {" + "return new Ice.Status.ComponentStatusManager('" + workingID + "', '" + idleID + "', '" + troubleID + "', '" + lostID + "', defaultStatusManager, " + component.isShowPopupOnDisconnect() + ", " + component.isDisplayHourglassWhenActive() + ");" + "});"));
            root.appendChild(script);
        }
        domContext.stepOver();
        domContext.streamWrite(context, uiComponent);
    }

    public Element getNextNode(DOMContext domContext, String classString, String label, String id, boolean visible) {
        Element div = domContext.createElement("div");
        div.setAttribute("id", id);
        div.setAttribute("class", classString);
        if (!visible) {
            div.setAttribute("style", "visibility: hidden;");
        }
        if (label != null) {
            label = DOMUtils.escapeAnsi((String)label);
        }
        Text text = domContext.createTextNode(label);
        div.appendChild(text);
        return div;
    }
}

