/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractMap;
import edu.emory.mathcs.backport.java.util.NavigableMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentNavigableMap;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class ConcurrentSkipListMap
extends AbstractMap
implements ConcurrentNavigableMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8627078645895051609L;
    private static final Object BASE_HEADER = new Object();
    private volatile transient HeadIndex head;
    private final Comparator comparator;
    private transient int randomSeed;
    private transient KeySet keySet;
    private transient EntrySet entrySet;
    private transient Values values;
    private transient DescendingKeySet descendingKeySet;
    private transient DescendingEntrySet descendingEntrySet;
    private static final int EQ = 1;
    private static final int LT = 2;
    private static final int GT = 0;

    final void initialize() {
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.descendingEntrySet = null;
        this.descendingKeySet = null;
        this.randomSeed = (int)Utils.nanoTime() | 1;
        this.head = new HeadIndex(new Node(null, BASE_HEADER, null), null, null, 1);
    }

    private synchronized boolean casHead(HeadIndex cmp, HeadIndex val) {
        if (this.head == cmp) {
            this.head = val;
            return true;
        }
        return false;
    }

    private Comparable comparable(Object key) throws ClassCastException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.comparator != null) {
            return new ComparableUsingComparator(key, this.comparator);
        }
        return (Comparable)key;
    }

    int compare(Object k1, Object k2) throws ClassCastException {
        Comparator cmp = this.comparator;
        if (cmp != null) {
            return cmp.compare(k1, k2);
        }
        return ((Comparable)k1).compareTo(k2);
    }

    boolean inHalfOpenRange(Object key, Object least, Object fence) {
        if (key == null) {
            throw new NullPointerException();
        }
        return !(least != null && this.compare(key, least) < 0 || fence != null && this.compare(key, fence) >= 0);
    }

    boolean inOpenRange(Object key, Object least, Object fence) {
        if (key == null) {
            throw new NullPointerException();
        }
        return !(least != null && this.compare(key, least) < 0 || fence != null && this.compare(key, fence) > 0);
    }

    private Node findPredecessor(Comparable key) {
        Index q;
        block0: while (true) {
            q = this.head;
            while (true) {
                Index d;
                Index r;
                if ((r = q.right) != null) {
                    if (r.indexesDeletedNode()) {
                        if (!q.unlink(r)) continue block0;
                        continue;
                    }
                    if (key.compareTo(r.key) > 0) {
                        q = r;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
            }
            break;
        }
        return q.node;
    }

    /*
     * Unable to fully structure code
     */
    private Node findNode(Comparable key) {
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v != n && b.value != null) ** break;
                continue block0;
                c = key.compareTo(n.key);
                if (c < 0) {
                    return null;
                }
                if (c == 0) {
                    return n;
                }
                b = n;
                n = f;
            }
            break;
        }
    }

    private Object doGet(Object okey) {
        Comparable key = this.comparable(okey);
        Object bound = null;
        Index q = this.head;
        while (true) {
            Index d;
            Object rk;
            Index r;
            if ((r = q.right) != null && (rk = r.key) != null && rk != bound) {
                int c = key.compareTo(rk);
                if (c > 0) {
                    q = r;
                    continue;
                }
                if (c == 0) {
                    Object v = r.node.value;
                    return v != null ? v : this.getUsingFindNode(key);
                }
                bound = rk;
            }
            if ((d = q.down) == null) break;
            q = d;
        }
        Node n = q.node.next;
        while (n != null) {
            Object nk = n.key;
            if (nk != null) {
                int c = key.compareTo(nk);
                if (c == 0) {
                    Object v = n.value;
                    return v != null ? v : this.getUsingFindNode(key);
                }
                if (c < 0) {
                    return null;
                }
            }
            n = n.next;
        }
        return null;
    }

    private Object getUsingFindNode(Comparable key) {
        Node n;
        Object v;
        do {
            if ((n = this.findNode(key)) != null) continue;
            return null;
        } while ((v = n.value) == null);
        return v;
    }

    private Object doPut(Object kkey, Object value, boolean onlyIfAbsent) {
        Node z;
        Comparable key = this.comparable(kkey);
        block0: while (true) {
            Node b = this.findPredecessor(key);
            Node n = b.next;
            while (n != null) {
                Node f = n.next;
                if (n != b.next) continue block0;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c > 0) {
                    b = n;
                    n = f;
                    continue;
                }
                if (c != 0) break;
                if (!onlyIfAbsent && !n.casValue(v, value)) continue block0;
                return v;
            }
            if (b.casNext(n, z = new Node(kkey, value, n))) break;
        }
        int level = this.randomLevel();
        if (level > 0) {
            this.insertIndex(z, level);
        }
        return null;
    }

    private int randomLevel() {
        int level = 0;
        int r = this.randomSeed;
        int x = r ^ r << 13;
        x ^= x >>> 17;
        this.randomSeed = x ^ x << 5;
        if (r < 0) {
            while ((r <<= 1) > 0) {
                ++level;
            }
        }
        return level;
    }

    /*
     * WARNING - void declaration
     */
    private void insertIndex(Node z, int level) {
        HeadIndex h = this.head;
        int max = h.level;
        if (level <= max) {
            Index idx = null;
            for (int i = 1; i <= level; ++i) {
                idx = new Index(z, idx, null);
            }
            this.addIndex(idx, h, level);
        } else {
            void var8_15;
            HeadIndex oldh;
            Index[] idxs;
            block7: {
                int k;
                int oldLevel;
                HeadIndex newh;
                level = max + 1;
                idxs = new Index[level + 1];
                Index idx = null;
                for (int i = 1; i <= level; ++i) {
                    idxs[i] = idx = new Index(z, idx, null);
                }
                do {
                    oldh = this.head;
                    oldLevel = oldh.level;
                    if (level <= oldLevel) {
                        k = level;
                        break block7;
                    }
                    newh = oldh;
                    Node oldbase = oldh.node;
                    for (int j = oldLevel + 1; j <= level; ++j) {
                        newh = new HeadIndex(oldbase, newh, idxs[j], j);
                    }
                } while (!this.casHead(oldh, newh));
                k = oldLevel;
            }
            this.addIndex(idxs[var8_15], oldh, (int)var8_15);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void addIndex(Index idx, HeadIndex h, int indexLevel) {
        insertionLevel = indexLevel;
        key = this.comparable(idx.key);
        block0: while (true) {
            q /* !! */  = h;
            t = idx;
            j = h.level;
            while (true) {
                if ((r = q /* !! */ .right) != null) {
                    c = key.compareTo(r.key);
                    if (r.indexesDeletedNode()) {
                        if (!q /* !! */ .unlink(r)) continue block0;
                        continue;
                    }
                    if (c > 0) {
                        q /* !! */  = r;
                        continue;
                    }
                }
                if (j == insertionLevel) {
                    if (t.indexesDeletedNode()) {
                        this.findNode(key);
                        return;
                    }
                    if (q /* !! */ .link(r, t)) ** break;
                    continue block0;
                    if (--insertionLevel == 0) {
                        if (t.indexesDeletedNode()) {
                            this.findNode(key);
                        }
                        return;
                    }
                }
                if (j > insertionLevel && j <= indexLevel) {
                    t = t.down;
                }
                q /* !! */  = q /* !! */ .down;
                --j;
            }
            break;
        }
    }

    private Object doRemove(Object okey, Object value) {
        Object v;
        Node f;
        Node n;
        Node b;
        Comparable key = this.comparable(okey);
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c < 0) {
                    return null;
                }
                if (c <= 0) break;
                b = n;
                n = f;
            }
            if (value != null && !value.equals(v)) {
                return null;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(key);
        } else {
            this.findPredecessor(key);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return v;
    }

    private void tryReduceLevel() {
        HeadIndex e;
        HeadIndex d;
        HeadIndex h = this.head;
        if (h.level > 3 && (d = (HeadIndex)h.down) != null && (e = (HeadIndex)d.down) != null && e.right == null && d.right == null && h.right == null && this.casHead(h, d) && h.right != null) {
            this.casHead(d, h);
        }
    }

    boolean removep(Object key) {
        return this.doRemove(key, null) != null;
    }

    Node findFirst() {
        while (true) {
            Node b = this.head.node;
            Node n = b.next;
            if (n == null) {
                return null;
            }
            if (n.value != null) {
                return n;
            }
            n.helpDelete(b, n.next);
        }
    }

    Object pollFirstKey() {
        Node f;
        Node n;
        Node b;
        while (true) {
            b = this.head.node;
            n = b.next;
            if (n == null) {
                return null;
            }
            f = n.next;
            if (n != b.next) continue;
            Object v = n.value;
            if (v == null) {
                n.helpDelete(b, f);
                continue;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        return n.key;
    }

    Map.Entry doRemoveFirstEntry() {
        Object v;
        Node f;
        Node n;
        Node b;
        while (true) {
            b = this.head.node;
            n = b.next;
            if (n == null) {
                return null;
            }
            f = n.next;
            if (n != b.next) continue;
            v = n.value;
            if (v == null) {
                n.helpDelete(b, f);
                continue;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        return new AbstractMap.SimpleImmutableEntry(n.key, v);
    }

    private void clearIndexToFirst() {
        block0: while (true) {
            Index q = this.head;
            do {
                Index r;
                if ((r = q.right) != null && r.indexesDeletedNode() && !q.unlink(r)) continue block0;
            } while ((q = q.down) != null);
            break;
        }
        if (this.head.right == null) {
            this.tryReduceLevel();
        }
    }

    Node findLast() {
        Index q = this.head;
        while (true) {
            Index r;
            if ((r = q.right) != null) {
                if (r.indexesDeletedNode()) {
                    q.unlink(r);
                    q = this.head;
                    continue;
                }
                q = r;
                continue;
            }
            Index d = q.down;
            if (d != null) {
                q = d;
                continue;
            }
            Node b = q.node;
            Node n = b.next;
            while (true) {
                if (n == null) {
                    return b.isBaseHeader() ? null : b;
                }
                Node f = n.next;
                if (n != b.next) break;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    break;
                }
                if (v == n || b.value == null) break;
                b = n;
                n = f;
            }
            q = this.head;
        }
    }

    private Node findPredecessorOfLast() {
        Index q;
        block0: while (true) {
            q = this.head;
            while (true) {
                Index d;
                Index r;
                if ((r = q.right) != null) {
                    if (r.indexesDeletedNode()) {
                        q.unlink(r);
                        continue block0;
                    }
                    if (r.node.next != null) {
                        q = r;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
            }
            break;
        }
        return q.node;
    }

    Object pollLastKey() {
        Node f;
        Node n;
        Node b;
        block0: while (true) {
            Object v;
            b = this.findPredecessorOfLast();
            n = b.next;
            if (n == null) {
                if (!b.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                if (f == null) break;
                b = n;
                n = f;
            }
            if (n.casValue(v, null)) break;
        }
        Object key = n.key;
        Comparable ck = this.comparable(key);
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(ck);
        } else {
            this.findPredecessor(ck);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return key;
    }

    Map.Entry doRemoveLastEntry() {
        Object v;
        Node f;
        Node n;
        Node b;
        block0: while (true) {
            b = this.findPredecessorOfLast();
            n = b.next;
            if (n == null) {
                if (!b.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                if (f == null) break;
                b = n;
                n = f;
            }
            if (n.casValue(v, null)) break;
        }
        Object key = n.key;
        Comparable ck = this.comparable(key);
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(ck);
        } else {
            this.findPredecessor(ck);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return new AbstractMap.SimpleImmutableEntry(key, v);
    }

    /*
     * Unable to fully structure code
     */
    Node findNear(Object kkey, int rel) {
        key = this.comparable(kkey);
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return (rel & 2) == 0 || b.isBaseHeader() != false ? null : b;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v != n && b.value != null) ** break;
                continue block0;
                c = key.compareTo(n.key);
                if (c == 0 && (rel & 1) != 0 || c < 0 && (rel & 2) == 0) {
                    return n;
                }
                if (c <= 0 && (rel & 2) != 0) {
                    return b.isBaseHeader() != false ? null : b;
                }
                b = n;
                n = f;
            }
            break;
        }
    }

    AbstractMap.SimpleImmutableEntry getNear(Object kkey, int rel) {
        Node n;
        AbstractMap.SimpleImmutableEntry e;
        do {
            if ((n = this.findNear(kkey, rel)) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    Node findCeiling(Object key) {
        return key == null ? this.findFirst() : this.findNear(key, 1);
    }

    Node findLower(Object key) {
        return key == null ? this.findLast() : this.findNear(key, 2);
    }

    Object getNearKey(Object kkey, int rel, Object least, Object fence) {
        Object k;
        Node n;
        Object v;
        Object key = kkey;
        if ((rel & 2) == 0 && this.compare(key, least) < 0) {
            key = least;
            rel |= 1;
        }
        do {
            if ((n = this.findNear(key, rel)) == null || !this.inHalfOpenRange(n.key, least, fence)) {
                return null;
            }
            k = n.key;
        } while ((v = n.getValidValue()) == null);
        return k;
    }

    Map.Entry getNearEntry(Object kkey, int rel, Object least, Object fence) {
        Object k;
        Node n;
        Object v;
        Object key = kkey;
        if ((rel & 2) == 0 && this.compare(key, least) < 0) {
            key = least;
            rel |= 1;
        }
        do {
            if ((n = this.findNear(key, rel)) == null || !this.inHalfOpenRange(n.key, least, fence)) {
                return null;
            }
            k = n.key;
        } while ((v = n.getValidValue()) == null);
        return new AbstractMap.SimpleImmutableEntry(k, v);
    }

    Map.Entry removeFirstEntryOfSubrange(Object least, Object fence) {
        Object k;
        Object v;
        do {
            Node n;
            if ((n = this.findCeiling(least)) == null) {
                return null;
            }
            k = n.key;
            if (fence == null || this.compare(k, fence) < 0) continue;
            return null;
        } while ((v = this.doRemove(k, null)) == null);
        return new AbstractMap.SimpleImmutableEntry(k, v);
    }

    Map.Entry removeLastEntryOfSubrange(Object least, Object fence) {
        Object k;
        Object v;
        do {
            Node n;
            if ((n = this.findLower(fence)) == null) {
                return null;
            }
            k = n.key;
            if (least == null || this.compare(k, least) >= 0) continue;
            return null;
        } while ((v = this.doRemove(k, null)) == null);
        return new AbstractMap.SimpleImmutableEntry(k, v);
    }

    public ConcurrentSkipListMap() {
        this.comparator = null;
        this.initialize();
    }

    public ConcurrentSkipListMap(Comparator comparator) {
        this.comparator = comparator;
        this.initialize();
    }

    public ConcurrentSkipListMap(Map m) {
        this.comparator = null;
        this.initialize();
        this.putAll(m);
    }

    public ConcurrentSkipListMap(SortedMap m) {
        this.comparator = m.comparator();
        this.initialize();
        this.buildFromSorted(m);
    }

    public Object clone() {
        ConcurrentSkipListMap clone = null;
        try {
            clone = (ConcurrentSkipListMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.initialize();
        clone.buildFromSorted(this);
        return clone;
    }

    private void buildFromSorted(SortedMap map) {
        if (map == null) {
            throw new NullPointerException();
        }
        HeadIndex h = this.head;
        Node basepred = h.node;
        ArrayList<Index> preds = new ArrayList<Index>();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Node z;
            Map.Entry e = it.next();
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            Object k = e.getKey();
            Object v = e.getValue();
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            basepred.next = z = new Node(k, v, null);
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node n = this.findFirst();
        while (n != null) {
            Object v = n.getValidValue();
            if (v != null) {
                s.writeObject(n.key);
                s.writeObject(v);
            }
            n = n.next;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object k;
        s.defaultReadObject();
        this.initialize();
        HeadIndex h = this.head;
        Node basepred = h.node;
        ArrayList<Index> preds = new ArrayList<Index>();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        while ((k = s.readObject()) != null) {
            Node z;
            Object v = s.readObject();
            if (v == null) {
                throw new NullPointerException();
            }
            Object key = k;
            Object val = v;
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            basepred.next = z = new Node(key, val, null);
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    public boolean containsKey(Object key) {
        return this.doGet(key) != null;
    }

    public Object get(Object key) {
        return this.doGet(key);
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, false);
    }

    public Object remove(Object key) {
        return this.doRemove(key, null);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Node n = this.findFirst();
        while (n != null) {
            Object v = n.getValidValue();
            if (v != null && value.equals(v)) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    public int size() {
        long count = 0L;
        Node n = this.findFirst();
        while (n != null) {
            if (n.getValidValue() != null) {
                ++count;
            }
            n = n.next;
        }
        return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }

    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    public void clear() {
        this.initialize();
    }

    public Set keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Set descendingKeySet() {
        DescendingKeySet ks = this.descendingKeySet;
        return ks != null ? ks : (this.descendingKeySet = new DescendingKeySet());
    }

    public Collection values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Set descendingEntrySet() {
        DescendingEntrySet es = this.descendingEntrySet;
        return es != null ? es : (this.descendingEntrySet = new DescendingEntrySet());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        try {
            Map.Entry e;
            Iterator<Object> itr = this.entrySet().iterator();
            while (itr.hasNext()) {
                e = (Map.Entry)itr.next();
                if (e.getValue().equals(m.get(e.getKey()))) continue;
                return false;
            }
            itr = m.entrySet().iterator();
            while (itr.hasNext()) {
                e = (Map.Entry)itr.next();
                Object k = e.getKey();
                Object v = e.getValue();
                if (k != null && v != null && v.equals(this.get(k))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    public Object putIfAbsent(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, true);
    }

    public boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        return this.doRemove(key, value) != null;
    }

    public boolean replace(Object key, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        Comparable k = this.comparable(key);
        while (true) {
            Node n;
            if ((n = this.findNode(k)) == null) {
                return false;
            }
            Object v = n.value;
            if (v == null) continue;
            if (!oldValue.equals(v)) {
                return false;
            }
            if (n.casValue(v, newValue)) break;
        }
        return true;
    }

    public Object replace(Object key, Object value) {
        Node n;
        Object v;
        if (value == null) {
            throw new NullPointerException();
        }
        Comparable k = this.comparable(key);
        do {
            if ((n = this.findNode(k)) != null) continue;
            return null;
        } while ((v = n.value) == null || !n.casValue(v, value));
        return v;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public Object firstKey() {
        Node n = this.findFirst();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    public Object lastKey() {
        Node n = this.findLast();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    public NavigableMap navigableSubMap(Object fromKey, Object toKey) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        return new ConcurrentSkipListSubMap(this, fromKey, toKey);
    }

    public NavigableMap navigableHeadMap(Object toKey) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        return new ConcurrentSkipListSubMap(this, null, toKey);
    }

    public NavigableMap navigableTailMap(Object fromKey) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        return new ConcurrentSkipListSubMap(this, fromKey, null);
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        return this.navigableSubMap(fromKey, toKey);
    }

    public SortedMap headMap(Object toKey) {
        return this.navigableHeadMap(toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        return this.navigableTailMap(fromKey);
    }

    public Map.Entry lowerEntry(Object key) {
        return this.getNear(key, 2);
    }

    public Object lowerKey(Object key) {
        Node n = this.findNear(key, 2);
        return n == null ? null : n.key;
    }

    public Map.Entry floorEntry(Object key) {
        return this.getNear(key, 3);
    }

    public Object floorKey(Object key) {
        Node n = this.findNear(key, 3);
        return n == null ? null : n.key;
    }

    public Map.Entry ceilingEntry(Object key) {
        return this.getNear(key, 1);
    }

    public Object ceilingKey(Object key) {
        Node n = this.findNear(key, 1);
        return n == null ? null : n.key;
    }

    public Map.Entry higherEntry(Object key) {
        return this.getNear(key, 0);
    }

    public Object higherKey(Object key) {
        Node n = this.findNear(key, 0);
        return n == null ? null : n.key;
    }

    public Map.Entry firstEntry() {
        Node n;
        AbstractMap.SimpleImmutableEntry e;
        do {
            if ((n = this.findFirst()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    public Map.Entry lastEntry() {
        Node n;
        AbstractMap.SimpleImmutableEntry e;
        do {
            if ((n = this.findLast()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    public Map.Entry pollFirstEntry() {
        return this.doRemoveFirstEntry();
    }

    public Map.Entry pollLastEntry() {
        return this.doRemoveLastEntry();
    }

    Iterator keyIterator() {
        return new KeyIterator();
    }

    Iterator descendingKeyIterator() {
        return new DescendingKeyIterator();
    }

    SubMapEntryIterator subMapEntryIterator(Object least, Object fence) {
        return new SubMapEntryIterator(least, fence);
    }

    DescendingSubMapEntryIterator descendingSubMapEntryIterator(Object least, Object fence) {
        return new DescendingSubMapEntryIterator(least, fence);
    }

    SubMapKeyIterator subMapKeyIterator(Object least, Object fence) {
        return new SubMapKeyIterator(least, fence);
    }

    DescendingSubMapKeyIterator descendingSubMapKeyIterator(Object least, Object fence) {
        return new DescendingSubMapKeyIterator(least, fence);
    }

    SubMapValueIterator subMapValueIterator(Object least, Object fence) {
        return new SubMapValueIterator(least, fence);
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static class ConcurrentSkipListSubMap
    extends AbstractMap
    implements ConcurrentNavigableMap,
    Serializable {
        private static final long serialVersionUID = -7647078645895051609L;
        private final ConcurrentSkipListMap m;
        private final Object least;
        private final Object fence;
        private transient Set keySetView;
        private transient Set entrySetView;
        private transient Collection valuesView;
        private transient Set descendingKeySetView;
        private transient Set descendingEntrySetView;

        ConcurrentSkipListSubMap(ConcurrentSkipListMap map, Object least, Object fence) {
            if (least != null && fence != null && map.compare(least, fence) > 0) {
                throw new IllegalArgumentException("inconsistent range");
            }
            this.m = map;
            this.least = least;
            this.fence = fence;
        }

        boolean inHalfOpenRange(Object key) {
            return this.m.inHalfOpenRange(key, this.least, this.fence);
        }

        boolean inOpenRange(Object key) {
            return this.m.inOpenRange(key, this.least, this.fence);
        }

        Node firstNode() {
            return this.m.findCeiling(this.least);
        }

        Node lastNode() {
            return this.m.findLower(this.fence);
        }

        boolean isBeforeEnd(Node n) {
            return n != null && (this.fence == null || n.key == null || this.m.compare(this.fence, n.key) > 0);
        }

        void checkKey(Object key) throws IllegalArgumentException {
            if (!this.inHalfOpenRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        ConcurrentSkipListMap getMap() {
            return this.m;
        }

        Object getLeast() {
            return this.least;
        }

        Object getFence() {
            return this.fence;
        }

        public boolean containsKey(Object key) {
            Object k = key;
            return this.inHalfOpenRange(k) && this.m.containsKey(k);
        }

        public Object get(Object key) {
            Object k = key;
            return !this.inHalfOpenRange(k) ? null : this.m.get(k);
        }

        public Object put(Object key, Object value) {
            this.checkKey(key);
            return this.m.put(key, value);
        }

        public Object remove(Object key) {
            Object k = key;
            return !this.inHalfOpenRange(k) ? null : this.m.remove(k);
        }

        public int size() {
            long count = 0L;
            Node n = this.firstNode();
            while (this.isBeforeEnd(n)) {
                if (n.getValidValue() != null) {
                    ++count;
                }
                n = n.next;
            }
            return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        }

        public boolean isEmpty() {
            return !this.isBeforeEnd(this.firstNode());
        }

        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Node n = this.firstNode();
            while (this.isBeforeEnd(n)) {
                Object v = n.getValidValue();
                if (v != null && value.equals(v)) {
                    return true;
                }
                n = n.next;
            }
            return false;
        }

        public void clear() {
            Node n = this.firstNode();
            while (this.isBeforeEnd(n)) {
                if (n.getValidValue() != null) {
                    this.m.remove(n.key);
                }
                n = n.next;
            }
        }

        public Object putIfAbsent(Object key, Object value) {
            this.checkKey(key);
            return this.m.putIfAbsent(key, value);
        }

        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inHalfOpenRange(k) && this.m.remove(k, value);
        }

        public boolean replace(Object key, Object oldValue, Object newValue) {
            this.checkKey(key);
            return this.m.replace(key, oldValue, newValue);
        }

        public Object replace(Object key, Object value) {
            this.checkKey(key);
            return this.m.replace(key, value);
        }

        public Comparator comparator() {
            return this.m.comparator();
        }

        public Object firstKey() {
            Node n = this.firstNode();
            if (this.isBeforeEnd(n)) {
                return n.key;
            }
            throw new NoSuchElementException();
        }

        public Object lastKey() {
            Object last;
            Node n = this.lastNode();
            if (n != null && this.inHalfOpenRange(last = n.key)) {
                return last;
            }
            throw new NoSuchElementException();
        }

        public NavigableMap navigableSubMap(Object fromKey, Object toKey) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            if (!this.inOpenRange(fromKey) || !this.inOpenRange(toKey)) {
                throw new IllegalArgumentException("key out of range");
            }
            return new ConcurrentSkipListSubMap(this.m, fromKey, toKey);
        }

        public NavigableMap navigableHeadMap(Object toKey) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            if (!this.inOpenRange(toKey)) {
                throw new IllegalArgumentException("key out of range");
            }
            return new ConcurrentSkipListSubMap(this.m, this.least, toKey);
        }

        public NavigableMap navigableTailMap(Object fromKey) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            if (!this.inOpenRange(fromKey)) {
                throw new IllegalArgumentException("key out of range");
            }
            return new ConcurrentSkipListSubMap(this.m, fromKey, this.fence);
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return this.navigableSubMap(fromKey, toKey);
        }

        public SortedMap headMap(Object toKey) {
            return this.navigableHeadMap(toKey);
        }

        public SortedMap tailMap(Object fromKey) {
            return this.navigableTailMap(fromKey);
        }

        public Map.Entry ceilingEntry(Object key) {
            return this.m.getNearEntry(key, 0 | 1, this.least, this.fence);
        }

        public Object ceilingKey(Object key) {
            return this.m.getNearKey(key, 0 | 1, this.least, this.fence);
        }

        public Map.Entry lowerEntry(Object key) {
            return this.m.getNearEntry(key, 2, this.least, this.fence);
        }

        public Object lowerKey(Object key) {
            return this.m.getNearKey(key, 2, this.least, this.fence);
        }

        public Map.Entry floorEntry(Object key) {
            return this.m.getNearEntry(key, 2 | 1, this.least, this.fence);
        }

        public Object floorKey(Object key) {
            return this.m.getNearKey(key, 2 | 1, this.least, this.fence);
        }

        public Map.Entry higherEntry(Object key) {
            return this.m.getNearEntry(key, 0, this.least, this.fence);
        }

        public Object higherKey(Object key) {
            return this.m.getNearKey(key, 0, this.least, this.fence);
        }

        public Map.Entry firstEntry() {
            Node n;
            AbstractMap.SimpleImmutableEntry e;
            do {
                if (this.isBeforeEnd(n = this.firstNode())) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        public Map.Entry lastEntry() {
            Node n;
            AbstractMap.SimpleImmutableEntry e;
            do {
                if ((n = this.lastNode()) != null && this.inHalfOpenRange(n.key)) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        public Map.Entry pollFirstEntry() {
            return this.m.removeFirstEntryOfSubrange(this.least, this.fence);
        }

        public Map.Entry pollLastEntry() {
            return this.m.removeLastEntryOfSubrange(this.least, this.fence);
        }

        public Set keySet() {
            Set ks = this.keySetView;
            return ks != null ? ks : (this.keySetView = new KeySetView());
        }

        public Set descendingKeySet() {
            Set ks = this.descendingKeySetView;
            return ks != null ? ks : (this.descendingKeySetView = new DescendingKeySetView());
        }

        public Collection values() {
            Collection vs = this.valuesView;
            return vs != null ? vs : (this.valuesView = new ValuesView());
        }

        public Set entrySet() {
            Set es = this.entrySetView;
            return es != null ? es : (this.entrySetView = new EntrySetView());
        }

        public Set descendingEntrySet() {
            Set es = this.descendingEntrySetView;
            return es != null ? es : (this.descendingEntrySetView = new DescendingEntrySetView());
        }

        class DescendingEntrySetView
        extends EntrySetView {
            DescendingEntrySetView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.descendingSubMapEntryIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }
        }

        class EntrySetView
        extends AbstractSet {
            EntrySetView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.subMapEntryIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }

            public int size() {
                return ConcurrentSkipListSubMap.this.size();
            }

            public boolean isEmpty() {
                return ConcurrentSkipListSubMap.this.isEmpty();
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                if (!ConcurrentSkipListSubMap.this.inHalfOpenRange(key)) {
                    return false;
                }
                Object v = ConcurrentSkipListSubMap.this.m.get(key);
                return v != null && v.equals(e.getValue());
            }

            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                if (!ConcurrentSkipListSubMap.this.inHalfOpenRange(key)) {
                    return false;
                }
                return ConcurrentSkipListSubMap.this.m.remove(key, e.getValue());
            }

            public Object[] toArray() {
                ArrayList<AbstractMap.SimpleEntry> c = new ArrayList<AbstractMap.SimpleEntry>();
                Iterator itr = this.iterator();
                while (itr.hasNext()) {
                    Map.Entry e = (Map.Entry)itr.next();
                    c.add(new AbstractMap.SimpleEntry(e.getKey(), e.getValue()));
                }
                return c.toArray();
            }

            public Object[] toArray(Object[] a) {
                ArrayList<AbstractMap.SimpleEntry> c = new ArrayList<AbstractMap.SimpleEntry>();
                Iterator itr = this.iterator();
                while (itr.hasNext()) {
                    Map.Entry e = (Map.Entry)itr.next();
                    c.add(new AbstractMap.SimpleEntry(e.getKey(), e.getValue()));
                }
                return c.toArray(a);
            }
        }

        class ValuesView
        extends AbstractCollection {
            ValuesView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.subMapValueIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }

            public int size() {
                return ConcurrentSkipListSubMap.this.size();
            }

            public boolean isEmpty() {
                return ConcurrentSkipListSubMap.this.isEmpty();
            }

            public boolean contains(Object v) {
                return ConcurrentSkipListSubMap.this.containsValue(v);
            }

            public Object[] toArray() {
                ArrayList c = new ArrayList();
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    c.add(i.next());
                }
                return c.toArray();
            }

            public Object[] toArray(Object[] a) {
                ArrayList c = new ArrayList();
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    c.add(i.next());
                }
                return c.toArray(a);
            }
        }

        class DescendingKeySetView
        extends KeySetView {
            DescendingKeySetView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.descendingSubMapKeyIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }
        }

        class KeySetView
        extends AbstractSet {
            KeySetView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.subMapKeyIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }

            public int size() {
                return ConcurrentSkipListSubMap.this.size();
            }

            public boolean isEmpty() {
                return ConcurrentSkipListSubMap.this.isEmpty();
            }

            public boolean contains(Object k) {
                return ConcurrentSkipListSubMap.this.containsKey(k);
            }

            public Object[] toArray() {
                ArrayList c = new ArrayList();
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    c.add(i.next());
                }
                return c.toArray();
            }

            public Object[] toArray(Object[] a) {
                ArrayList c = new ArrayList();
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    c.add(i.next());
                }
                return c.toArray(a);
            }
        }
    }

    class DescendingEntrySet
    extends EntrySet {
        DescendingEntrySet() {
        }

        public Iterator iterator() {
            return new DescendingEntryIterator();
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ConcurrentSkipListMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentSkipListMap.this.remove(e.getKey(), e.getValue());
        }

        public boolean isEmpty() {
            return ConcurrentSkipListMap.this.isEmpty();
        }

        public int size() {
            return ConcurrentSkipListMap.this.size();
        }

        public void clear() {
            ConcurrentSkipListMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList<AbstractMap.SimpleEntry> c = new ArrayList<AbstractMap.SimpleEntry>();
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                c.add(new AbstractMap.SimpleEntry(e.getKey(), e.getValue()));
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList<AbstractMap.SimpleEntry> c = new ArrayList<AbstractMap.SimpleEntry>();
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                c.add(new AbstractMap.SimpleEntry(e.getKey(), e.getValue()));
            }
            return c.toArray(a);
        }
    }

    final class Values
    extends AbstractCollection {
        Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public boolean isEmpty() {
            return ConcurrentSkipListMap.this.isEmpty();
        }

        public int size() {
            return ConcurrentSkipListMap.this.size();
        }

        public boolean contains(Object o) {
            return ConcurrentSkipListMap.this.containsValue(o);
        }

        public void clear() {
            ConcurrentSkipListMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    class DescendingKeySet
    extends KeySet {
        DescendingKeySet() {
        }

        public Iterator iterator() {
            return new DescendingKeyIterator();
        }
    }

    class KeySet
    extends AbstractSet {
        KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean isEmpty() {
            return ConcurrentSkipListMap.this.isEmpty();
        }

        public int size() {
            return ConcurrentSkipListMap.this.size();
        }

        public boolean contains(Object o) {
            return ConcurrentSkipListMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return ConcurrentSkipListMap.this.removep(o);
        }

        public void clear() {
            ConcurrentSkipListMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    final class DescendingSubMapEntryIterator
    extends EntryIter
    implements Iterator {
        final Object least;

        DescendingSubMapEntryIterator(Object least, Object fence) {
            this.initDescending(least, fence);
            this.least = least;
        }

        public Object next() {
            this.lastValue = this.nextValue;
            this.descend(this.least);
            return this;
        }
    }

    final class DescendingEntryIterator
    extends EntryIter
    implements Iterator {
        DescendingEntryIterator() {
            this.initDescending();
        }

        public Object next() {
            this.lastValue = this.nextValue;
            this.descend();
            return this;
        }
    }

    final class SubMapEntryIterator
    extends EntryIter
    implements Iterator {
        final Object fence;

        SubMapEntryIterator(Object least, Object fence) {
            this.initAscending(least, fence);
            this.fence = fence;
        }

        public Object next() {
            this.lastValue = this.nextValue;
            this.ascend(this.fence);
            return this;
        }
    }

    final class EntryIterator
    extends EntryIter
    implements Iterator {
        EntryIterator() {
            this.initAscending();
        }

        public Object next() {
            this.lastValue = this.nextValue;
            this.ascend();
            return this;
        }
    }

    abstract class EntryIter
    extends Iter
    implements Map.Entry {
        Object lastValue;

        EntryIter() {
        }

        public Object getKey() {
            Node l = this.last;
            if (l == null) {
                throw new IllegalStateException();
            }
            return l.key;
        }

        public Object getValue() {
            Object v = this.lastValue;
            if (this.last == null || v == null) {
                throw new IllegalStateException();
            }
            return v;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (this.last == null) {
                return super.equals(o);
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.getKey().equals(e.getKey()) && this.getValue().equals(e.getValue());
        }

        public int hashCode() {
            if (this.last == null) {
                return super.hashCode();
            }
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        public String toString() {
            if (this.last == null) {
                return super.toString();
            }
            return this.getKey() + "=" + this.getValue();
        }
    }

    final class DescendingSubMapKeyIterator
    extends Iter
    implements Iterator {
        final Object least;

        DescendingSubMapKeyIterator(Object least, Object fence) {
            this.initDescending(least, fence);
            this.least = least;
        }

        public Object next() {
            Node n = this.next;
            this.descend(this.least);
            return n.key;
        }
    }

    final class DescendingKeyIterator
    extends Iter
    implements Iterator {
        DescendingKeyIterator() {
            this.initDescending();
        }

        public Object next() {
            Node n = this.next;
            this.descend();
            return n.key;
        }
    }

    final class SubMapKeyIterator
    extends Iter
    implements Iterator {
        final Object fence;

        SubMapKeyIterator(Object least, Object fence) {
            this.initAscending(least, fence);
            this.fence = fence;
        }

        public Object next() {
            Node n = this.next;
            this.ascend(this.fence);
            return n.key;
        }
    }

    class SubMapValueIterator
    extends Iter
    implements Iterator {
        final Object fence;

        SubMapValueIterator(Object least, Object fence) {
            this.initAscending(least, fence);
            this.fence = fence;
        }

        public Object next() {
            Object v = this.nextValue;
            this.ascend(this.fence);
            return v;
        }
    }

    final class KeyIterator
    extends Iter
    implements Iterator {
        KeyIterator() {
            this.initAscending();
        }

        public Object next() {
            Node n = this.next;
            this.ascend();
            return n.key;
        }
    }

    final class ValueIterator
    extends Iter
    implements Iterator {
        ValueIterator() {
            this.initAscending();
        }

        public Object next() {
            Object v = this.nextValue;
            this.ascend();
            return v;
        }
    }

    abstract class Iter {
        Node last;
        Node next;
        Object nextValue;

        Iter() {
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final void initAscending() {
            do {
                this.next = ConcurrentSkipListMap.this.findFirst();
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void initAscending(Object least, Object fence) {
            block2: {
                do {
                    this.next = ConcurrentSkipListMap.this.findCeiling(least);
                    if (this.next == null) break block2;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (fence != null && ConcurrentSkipListMap.this.compare(fence, this.next.key) <= 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        final void ascend() {
            this.last = this.next;
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            do {
                this.next = this.next.next;
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void ascend(Object fence) {
            block3: {
                this.last = this.next;
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                do {
                    this.next = this.next.next;
                    if (this.next == null) break block3;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (fence != null && ConcurrentSkipListMap.this.compare(fence, this.next.key) <= 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        final void initDescending() {
            do {
                this.next = ConcurrentSkipListMap.this.findLast();
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void initDescending(Object least, Object fence) {
            block2: {
                do {
                    this.next = ConcurrentSkipListMap.this.findLower(fence);
                    if (this.next == null) break block2;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (least != null && ConcurrentSkipListMap.this.compare(least, this.next.key) > 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        final void descend() {
            this.last = this.next;
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            Object k = this.last.key;
            do {
                this.next = ConcurrentSkipListMap.this.findNear(k, 2);
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void descend(Object least) {
            block3: {
                this.last = this.next;
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                Object k = this.last.key;
                do {
                    this.next = ConcurrentSkipListMap.this.findNear(k, 2);
                    if (this.next == null) break block3;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (least != null && ConcurrentSkipListMap.this.compare(least, this.next.key) > 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        public void remove() {
            Node l = this.last;
            if (l == null) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListMap.this.remove(l.key);
        }
    }

    static final class ComparableUsingComparator
    implements Comparable {
        final Object actualKey;
        final Comparator cmp;

        ComparableUsingComparator(Object key, Comparator cmp) {
            this.actualKey = key;
            this.cmp = cmp;
        }

        public int compareTo(Object k2) {
            return this.cmp.compare(this.actualKey, k2);
        }
    }

    static final class HeadIndex
    extends Index {
        final int level;

        HeadIndex(Node node, Index down, Index right, int level) {
            super(node, down, right);
            this.level = level;
        }
    }

    static class Index {
        final Object key;
        final Node node;
        final Index down;
        volatile Index right;

        Index(Node node, Index down, Index right) {
            this.node = node;
            this.key = node.key;
            this.down = down;
            this.right = right;
        }

        final synchronized boolean casRight(Index cmp, Index val) {
            if (this.right == cmp) {
                this.right = val;
                return true;
            }
            return false;
        }

        final boolean indexesDeletedNode() {
            return this.node.value == null;
        }

        final boolean link(Index succ, Index newSucc) {
            Node n = this.node;
            newSucc.right = succ;
            return n.value != null && this.casRight(succ, newSucc);
        }

        final boolean unlink(Index succ) {
            return !this.indexesDeletedNode() && this.casRight(succ, succ.right);
        }
    }

    static final class Node {
        final Object key;
        volatile Object value;
        volatile Node next;

        Node(Object key, Object value, Node next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        Node(Node next) {
            this.key = null;
            this.value = this;
            this.next = next;
        }

        synchronized boolean casValue(Object cmp, Object val) {
            if (this.value == cmp) {
                this.value = val;
                return true;
            }
            return false;
        }

        synchronized boolean casNext(Node cmp, Node val) {
            if (this.next == cmp) {
                this.next = val;
                return true;
            }
            return false;
        }

        boolean isMarker() {
            return this.value == this;
        }

        boolean isBaseHeader() {
            return this.value == BASE_HEADER;
        }

        boolean appendMarker(Node f) {
            return this.casNext(f, new Node(f));
        }

        void helpDelete(Node b, Node f) {
            if (f == this.next && this == b.next) {
                if (f == null || f.value != f) {
                    this.appendMarker(f);
                } else {
                    b.casNext(this, f.next);
                }
            }
        }

        Object getValidValue() {
            Object v = this.value;
            if (v == this || v == BASE_HEADER) {
                return null;
            }
            return v;
        }

        AbstractMap.SimpleImmutableEntry createSnapshot() {
            Object v = this.getValidValue();
            if (v == null) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry(this.key, v);
        }
    }
}

