/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.util.event.servlet.ContextDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ContextEventListener;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.util.event.servlet.ICEfacesIDDisposedEvent;
import com.icesoft.faces.util.event.servlet.ICEfacesIDRetrievedEvent;
import com.icesoft.faces.util.event.servlet.SessionDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ViewNumberRetrievedEvent;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.MainSessionBoundServlet;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TomcatPushServlet
extends HttpServlet
implements CometProcessor,
ContextEventListener {
    private static final Log LOG = LogFactory.getLog(TomcatPushServlet.class);
    private final Map eventResponderMap = new HashMap();

    public void contextDestroyed(ContextDestroyedEvent event) {
    }

    public void destroy() {
    }

    public void event(CometEvent event) throws IOException, ServletException {
        CometEvent.EventType eventType = event.getEventType();
        if (eventType == CometEvent.EventType.BEGIN) {
            this.begin(event);
        } else if (eventType == CometEvent.EventType.READ) {
            this.read(event);
        } else if (eventType == CometEvent.EventType.END) {
            this.end(event);
        } else if (eventType == CometEvent.EventType.ERROR) {
            this.error(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iceFacesIdDisposed(ICEfacesIDDisposedEvent event) {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException exception) {
            // empty catch block
        }
        HttpSession session = event.getHttpSession();
        Map map = this.eventResponderMap;
        synchronized (map) {
            if (this.eventResponderMap.containsKey(session)) {
                ((EventResponder)this.eventResponderMap.get(session)).dispose();
            }
        }
    }

    public void iceFacesIdRetrieved(ICEfacesIDRetrievedEvent event) {
    }

    public void init() throws ServletException {
        ContextEventRepeater.addListener(this);
    }

    public boolean receiveBufferedEvents() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(SessionDestroyedEvent event) {
        HttpSession session = event.getHttpSession();
        Map map = this.eventResponderMap;
        synchronized (map) {
            if (this.eventResponderMap.containsKey(session)) {
                this.eventResponderMap.remove(session);
            }
        }
    }

    public void viewNumberRetrieved(ViewNumberRetrievedEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void begin(CometEvent event) throws IOException, ServletException {
        HttpSession session = event.getHttpServletRequest().getSession(false);
        Map map = this.eventResponderMap;
        synchronized (map) {
            if (!this.eventResponderMap.containsKey(session)) {
                MainSessionBoundServlet server = (MainSessionBoundServlet)SessionDispatcher.getSingletonSessionServer(session, this.getServletContext());
                this.eventResponderMap.put(session, new EventResponder(server.getSessionID(), server.getAllUpdatedViews(), server.getSynchronouslyUpdatedViews()));
            }
        }
    }

    protected void end(CometEvent event) throws IOException, ServletException {
        event.close();
    }

    protected void error(CometEvent event) throws IOException, ServletException {
        event.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(CometEvent event) throws IOException, ServletException {
        EventResponder eventResponder;
        HttpServletRequest request = event.getHttpServletRequest();
        ServletInputStream in = request.getInputStream();
        byte[] buffer = new byte[4096];
        try {
            do {
                int n;
                if ((n = in.read(buffer)) > 0 || n != -1) continue;
                this.error(event);
                return;
            } while (in.available() > 0);
        }
        catch (EOFException exception) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An EOF exception occurred while trying to read the request.", (Throwable)exception);
            }
            this.error(event);
            return;
        }
        catch (IOException exception) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An I/O error occurred while trying to read the request.", (Throwable)exception);
            }
            this.error(event);
            return;
        }
        HttpSession session = request.getSession(false);
        Object object = this.eventResponderMap;
        synchronized (object) {
            eventResponder = this.eventResponderMap.containsKey(session) ? (EventResponder)this.eventResponderMap.get(session) : null;
        }
        if (eventResponder != null) {
            object = eventResponder.allUpdatedViews;
            synchronized (object) {
                if (eventResponder.sendResponse(event.getHttpServletResponse())) {
                    event.close();
                } else {
                    eventResponder.pendingRequest = event;
                }
            }
        } else {
            this.error(event);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        throw new ServletException("service() not supported by TomcatPushServlet. Configure the connector, replacing protocol=\"HTTP/1.1\" with protocol=\"org.apache.coyote.http11.Http11NioProtocol\"");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventResponder
    implements Runnable {
        private static final Log LOG = LogFactory.getLog(EventResponder.class);
        private final String sessionID;
        private final ViewQueue allUpdatedViews;
        private final Collection synchronouslyUpdatedViews;
        private CometEvent pendingRequest;
        private final ResponseSender UpdatedViewsSender = new ResponseSender(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean send(HttpServletResponse response) throws IOException {
                ViewQueue viewQueue = EventResponder.this.allUpdatedViews;
                synchronized (viewQueue) {
                    Set updatedViewSet = EventResponder.this.getUpdatedViews();
                    if (!updatedViewSet.isEmpty()) {
                        response.setContentType("text/xml; charset=UTF-8");
                        response.addHeader("X-Powered-By", "Tomcat Push Servlet");
                        String[] viewIdentifiers = updatedViewSet.toArray(new String[updatedViewSet.size()]);
                        PrintWriter writer = response.getWriter();
                        writer.write("<updated-views>");
                        for (int i = 0; i < viewIdentifiers.length; ++i) {
                            if (i != 0) {
                                writer.write(32);
                            }
                            writer.write(EventResponder.this.sessionID + ":" + viewIdentifiers[i]);
                        }
                        writer.write("</updated-views>");
                        writer.flush();
                        return true;
                    }
                    return false;
                }
            }
        };
        private final ResponseSender LastUpdatedViewsSender = new ResponseSender(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean send(HttpServletResponse response) throws IOException {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ViewQueue viewQueue = EventResponder.this.allUpdatedViews;
                synchronized (viewQueue) {
                    Set updatedViewSet = EventResponder.this.getUpdatedViews();
                    if (!updatedViewSet.isEmpty()) {
                        response.setContentType("text/xml; charset=UTF-8");
                        response.addHeader("X-Powered-By", "Tomcat Push Servlet");
                        String[] viewIdentifiers = updatedViewSet.toArray(new String[updatedViewSet.size()]);
                        PrintWriter writer = response.getWriter();
                        writer.write("<updated-views>");
                        for (int i = 0; i < viewIdentifiers.length; ++i) {
                            if (i != 0) {
                                writer.write(32);
                            }
                            writer.write(EventResponder.this.sessionID + ":" + viewIdentifiers[i]);
                        }
                        writer.write("</updated-views>");
                        writer.flush();
                        EventResponder.this.responseSender = EventResponder.this.ConnectionCloseSender;
                        return true;
                    }
                    return false;
                }
            }
        };
        private final ResponseSender ConnectionCloseSender = new ResponseSender(){

            public boolean send(HttpServletResponse response) throws IOException {
                response.setHeader("Content-Length", "0");
                response.setHeader("X-Connection", "close");
                response.addHeader("X-Powered-By", "Tomcat Push Servlet");
                return true;
            }
        };
        private ResponseSender responseSender = this.UpdatedViewsSender;

        private EventResponder(String sessionID, ViewQueue allUpdatedViews, Collection synchronouslyUpdatedViews) {
            this.sessionID = sessionID;
            this.allUpdatedViews = allUpdatedViews;
            this.allUpdatedViews.onPut(this);
            this.synchronouslyUpdatedViews = synchronouslyUpdatedViews;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ViewQueue viewQueue = this.allUpdatedViews;
            synchronized (viewQueue) {
                block7: {
                    if (this.pendingRequest != null) {
                        try {
                            if (this.sendResponse(this.pendingRequest.getHttpServletResponse())) {
                                this.pendingRequest.close();
                                this.pendingRequest = null;
                            }
                        }
                        catch (IOException exception) {
                            if (!LOG.isErrorEnabled()) break block7;
                            LOG.error((Object)"An I/O error occurred while trying to send a response.", (Throwable)exception);
                        }
                    }
                }
            }
        }

        private void dispose() {
            this.responseSender = this.LastUpdatedViewsSender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> getUpdatedViews() {
            HashSet<String> viewIdentifierSet;
            ViewQueue viewQueue = this.allUpdatedViews;
            synchronized (viewQueue) {
                this.allUpdatedViews.removeAll(this.synchronouslyUpdatedViews);
                this.synchronouslyUpdatedViews.clear();
                viewIdentifierSet = new HashSet<String>((Collection<String>)((Object)this.allUpdatedViews));
                this.allUpdatedViews.clear();
            }
            return viewIdentifierSet;
        }

        private boolean sendResponse(HttpServletResponse response) throws IOException {
            return this.responseSender.send(response);
        }

        private static interface ResponseSender {
            public boolean send(HttpServletResponse var1) throws IOException;
        }
    }
}

