/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.env.AuthenticationVerifier;
import com.icesoft.faces.env.RequestAttributes;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.servlet.InterceptingServletSession;
import com.icesoft.faces.webapp.http.servlet.ServletContextAttributeMap;
import com.icesoft.faces.webapp.http.servlet.ServletContextInitParameterMap;
import com.icesoft.faces.webapp.http.servlet.ServletEnvironmentRequest;
import com.icesoft.faces.webapp.http.servlet.ServletRequestAttributeMap;
import com.icesoft.faces.webapp.http.servlet.ServletRequestAttributes;
import com.icesoft.faces.webapp.http.servlet.ServletSessionAttributeMap;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletExternalContext
extends BridgeExternalContext {
    private static final Log Log = LogFactory.getLog((Class)ServletExternalContext.class);
    private final ServletContext context;
    private final HttpSession session;
    private AuthenticationVerifier authenticationVerifier;
    private RequestAttributes requestAttributes;
    private HttpServletRequest initialRequest;
    private HttpServletResponse response;
    private BridgeExternalContext.Dispatcher dispatcher;
    private List locales;

    public ServletExternalContext(String viewIdentifier, Object req, Object response, CommandQueue commandQueue, Configuration configuration, SessionDispatcher.Monitor sessionMonitor) {
        super(viewIdentifier, commandQueue, configuration);
        HttpServletRequest request = (HttpServletRequest)req;
        this.session = new InterceptingServletSession(request.getSession(), sessionMonitor);
        this.context = this.session.getServletContext();
        this.initParameterMap = new ServletContextInitParameterMap(this.context);
        this.applicationMap = new ServletContextAttributeMap(this.context);
        this.sessionMap = new ServletSessionAttributeMap(this.session);
        this.requestMap = Collections.EMPTY_MAP;
        this.updateOnPageLoad(request, response);
        this.insertNewViewrootToken();
        this.switchToNormalMode();
    }

    public Object getSession(boolean create) {
        return this.session;
    }

    public Object getContext() {
        return this.context;
    }

    public Object getRequest() {
        return this.initialRequest;
    }

    public Object getResponse() {
        return this.response;
    }

    public void update(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        boolean persistSeamKey = this.isSeamLifecycleShortcut();
        this.recreateParameterAndCookieMaps();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.requestParameterMap.put(name, request.getParameter(name));
            this.requestParameterValuesMap.put(name, request.getParameterValues(name));
        }
        Enumeration headerParameterNames = request.getHeaderNames();
        while (headerParameterNames.hasMoreElements()) {
            String name = (String)headerParameterNames.nextElement();
            this.requestHeaderMap.put(name, request.getHeader(name));
            this.requestHeaderValuesMap.put(name, request.getHeaders(name));
        }
        ((ServletEnvironmentRequest)this.initialRequest).setParameters(request);
        if (persistSeamKey) {
            this.setSeamLifecycleShortcut();
        }
        if ((cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                this.requestCookieMap.put(cookie.getName(), cookie);
            }
        }
        this.requestAttributes = new ServletRequestAttributes(request);
        this.locales = Collections.list(request.getLocales());
        this.authenticationVerifier = ServletExternalContext.createAuthenticationVerifier(request);
        this.dispatcher = CannotDispatchOnXMLHTTPRequest;
        this.response = response;
    }

    public void updateOnPageLoad(Object request, Object response) {
        final HttpServletRequest servletRequest = (HttpServletRequest)request;
        final HttpServletResponse servletResponse = (HttpServletResponse)response;
        this.initialRequest = new ServletEnvironmentRequest(request, this.session){

            public RequestAttributes requestAttributes() {
                return ServletExternalContext.this.requestAttributes;
            }

            public AuthenticationVerifier authenticationVerifier() {
                return ServletExternalContext.this.authenticationVerifier;
            }

            public Enumeration getLocales() {
                return Collections.enumeration(ServletExternalContext.this.locales);
            }
        };
        Map previousRequestMap = this.requestMap;
        this.requestMap = Collections.synchronizedMap(new ServletRequestAttributeMap((ServletRequest)this.initialRequest));
        this.requestMap.putAll(previousRequestMap);
        this.update(servletRequest, servletResponse);
        this.dispatcher = new BridgeExternalContext.Dispatcher(){

            public void dispatch(String path) throws IOException, FacesException {
                try {
                    servletRequest.getRequestDispatcher(path).forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                }
                catch (ServletException e) {
                    throw new FacesException((Throwable)e);
                }
            }
        };
    }

    public Map getRequestHeaderMap() {
        return this.requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        return this.requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        return this.initialRequest.getLocale();
    }

    public Iterator getRequestLocales() {
        return Collections.list(this.initialRequest.getLocales()).iterator();
    }

    public String getRequestPathInfo() {
        return ServletExternalContext.convertEmptyStringToNull(this.requestPathInfo == null ? this.initialRequest.getPathInfo() : this.requestPathInfo);
    }

    public String getRequestURI() {
        String requestURI = (String)this.initialRequest.getAttribute("javax.servlet.forward.request_uri");
        return requestURI == null ? this.initialRequest.getRequestURI() : requestURI;
    }

    public String getRequestContextPath() {
        String contextPath = (String)this.initialRequest.getAttribute("javax.servlet.forward.context_path");
        return contextPath == null ? this.initialRequest.getContextPath() : contextPath;
    }

    public String getRequestServletPath() {
        boolean callFromMyfaces = new Exception().getStackTrace()[1].getClassName().startsWith("org.apache.myfaces");
        if (callFromMyfaces) {
            return this.requestServletPath == null ? this.initialRequest.getServletPath() : this.requestServletPath;
        }
        String servletPath = (String)this.initialRequest.getAttribute("javax.servlet.forward.servlet_path");
        return servletPath == null ? this.initialRequest.getServletPath() : servletPath;
    }

    public Set getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public String encodeActionURL(String url) {
        return url;
    }

    public String encodeResourceURL(String url) {
        try {
            return this.response.encodeURL(url);
        }
        catch (Exception e) {
            return url;
        }
    }

    public String encodeNamespace(String name) {
        return name;
    }

    public void dispatch(String path) throws IOException, FacesException {
        this.dispatcher.dispatch(path);
    }

    public void log(String message) {
        this.context.log(message);
    }

    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    public String getAuthType() {
        return this.initialRequest.getAuthType();
    }

    public String getRemoteUser() {
        return this.initialRequest.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.initialRequest.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.initialRequest.isUserInRole(role);
    }

    public Writer getWriter(String encoding) throws IOException {
        try {
            return new OutputStreamWriter((OutputStream)this.response.getOutputStream(), encoding);
        }
        catch (IllegalStateException e) {
            return this.response.getWriter();
        }
    }

    public void switchToNormalMode() {
        this.redirector = new BridgeExternalContext.Redirector(){

            public void redirect(String uri) {
                try {
                    ServletExternalContext.this.response.sendRedirect(uri);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.cookieTransporter = new BridgeExternalContext.CookieTransporter(){

            public void send(Cookie cookie) {
                ServletExternalContext.this.response.addCookie(cookie);
            }
        };
    }

    public void switchToPushMode() {
        this.redirector = new BridgeExternalContext.CommandQueueRedirector();
        this.cookieTransporter = new BridgeExternalContext.CommandQueueCookieTransporter();
    }

    public void release() {
        String requestServletPath = (String)this.requestAttributes.getAttribute("org.jboss.seam.web.requestServletPath");
        String requestContextPath = (String)this.requestAttributes.getAttribute("org.jboss.seam.web.requestContextPath");
        super.release();
        if (SeamUtilities.isSeamEnvironment()) {
            this.requestAttributes.setAttribute("org.jboss.seam.web.requestServletPath", requestServletPath);
            this.requestAttributes.setAttribute("org.jboss.seam.web.requestContextPath", requestContextPath);
            this.requestAttributes.setAttribute("org.jboss.seam.web.requestPathInfo", "");
        } else {
            this.requestAttributes = NOOPRequestAttributes;
        }
        this.dispatcher = RequestNotAvailable;
        this.authenticationVerifier = ServletExternalContext.releaseVerifier(this.authenticationVerifier);
    }

    public void removeSeamAttributes() {
        this.requestAttributes = NOOPRequestAttributes;
    }

    private static String convertEmptyStringToNull(String val) {
        return val == null || val.trim().length() == 0 ? null : val;
    }
}

