/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.http.core.LifecycleExecutor;
import com.icesoft.faces.webapp.http.servlet.SpringWebFlowInstantiationServlet;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.registry.NoSuchFlowDefinitionException;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;

public class SwfLifecycleExecutor
extends LifecycleExecutor {
    private static Log log = LogFactory.getLog((Class)SwfLifecycleExecutor.class);
    private static final String SERVLET_RELATIVE_LOCATION_PREFIX = "servletRelative:";
    private static final String CONTEXT_RELATIVE_LOCATION_PREFIX = "contextRelative:";
    private static final String SERVER_RELATIVE_LOCATION_PREFIX = "serverRelative:";
    private FlowUrlHandler flowUrlHandler = new DefaultFlowUrlHandler();

    public void apply(FacesContext facesContext) {
        FlowExecutor flowExecutor = SpringWebFlowInstantiationServlet.getFlowExecutor();
        ExternalContext externalContext = facesContext.getExternalContext();
        ServletContext servletContext = (ServletContext)externalContext.getContext();
        HttpServletRequest servletRequest = (HttpServletRequest)externalContext.getRequest();
        HttpServletResponse servletResponse = (HttpServletResponse)externalContext.getResponse();
        String flowExecutionKey = servletRequest.getParameter("org.springframework.webflow.FlowExecutionKey");
        String flowId = this.firstSegment(servletRequest.getPathInfo());
        try {
            FlowExecutionResult result;
            ServletExternalContext servletExternalContext = new ServletExternalContext(servletContext, servletRequest, servletResponse);
            servletExternalContext.setAjaxRequest(true);
            if (null != flowExecutionKey) {
                result = flowExecutor.resumeExecution(flowExecutionKey, (org.springframework.webflow.context.ExternalContext)servletExternalContext);
            } else {
                MutableAttributeMap input = this.defaultFlowExecutionInputMap(servletRequest);
                result = flowExecutor.launchExecution(flowId, input, (org.springframework.webflow.context.ExternalContext)servletExternalContext);
            }
            this.handleFlowExecutionResult(result, servletExternalContext, servletRequest, servletResponse);
        }
        catch (NoSuchFlowDefinitionException e) {
            jsfExecutor.apply(facesContext);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public String firstSegment(String path) {
        String path1 = path.substring(1);
        int end = path1.indexOf("/");
        if (-1 == end) {
            end = path1.length();
        }
        path1 = path1.substring(0, end);
        return path1;
    }

    private void handleFlowExecutionResult(FlowExecutionResult result, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (result.isPaused()) {
            if (context.getFlowExecutionRedirectRequested()) {
                this.sendFlowExecutionRedirect(result, context, request, response);
            } else if (context.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(result, context, request, response);
            } else if (context.getExternalRedirectRequested()) {
                this.sendExternalRedirect(context.getExternalRedirectUrl(), request, response);
            }
        } else if (result.isEnded()) {
            if (context.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(result, context, request, response);
            } else if (context.getExternalRedirectRequested()) {
                this.sendExternalRedirect(context.getExternalRedirectUrl(), request, response);
            } else {
                this.defaultHandleExecutionOutcome(result.getFlowId(), result.getOutcome(), request, response);
            }
        } else {
            throw new IllegalStateException("Execution result should have been one of [paused] or [ended]");
        }
    }

    protected void defaultHandleExecutionOutcome(String flowId, FlowExecutionOutcome outcome, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!response.isCommitted()) {
            response.sendRedirect(this.flowUrlHandler.createFlowDefinitionUrl(flowId, outcome.getOutput(), request));
        }
    }

    private void sendFlowExecutionRedirect(FlowExecutionResult result, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = this.flowUrlHandler.createFlowExecutionUrl(result.getFlowId(), result.getPausedKey(), request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending flow execution redirect to '" + url + "'"));
        }
        this.sendRedirect(url, request, response);
    }

    private void sendFlowDefinitionRedirect(FlowExecutionResult result, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String flowId = context.getFlowRedirectFlowId();
        MutableAttributeMap input = context.getFlowRedirectFlowInput();
        if (result.isPaused()) {
            input.put("refererExecution", (Object)result.getPausedKey());
        }
        String url = this.flowUrlHandler.createFlowDefinitionUrl(flowId, (AttributeMap)input, request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending flow definition redirect to '" + url + "'"));
        }
        this.sendRedirect(url, request, response);
    }

    private void sendExternalRedirect(String location, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending external redirect to '" + location + "'"));
        }
        if (location.startsWith(SERVLET_RELATIVE_LOCATION_PREFIX)) {
            this.sendServletRelativeRedirect(location.substring(SERVLET_RELATIVE_LOCATION_PREFIX.length()), request, response);
        } else if (location.startsWith(CONTEXT_RELATIVE_LOCATION_PREFIX)) {
            StringBuffer url = new StringBuffer(request.getContextPath());
            String contextRelativeUrl = location.substring(CONTEXT_RELATIVE_LOCATION_PREFIX.length());
            if (!contextRelativeUrl.startsWith("/")) {
                url.append('/');
            }
            url.append(contextRelativeUrl);
            this.sendRedirect(url.toString(), request, response);
        } else if (location.startsWith(SERVER_RELATIVE_LOCATION_PREFIX)) {
            String url = location.substring(SERVER_RELATIVE_LOCATION_PREFIX.length());
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            this.sendRedirect(url, request, response);
        } else if (location.startsWith("http://") || location.startsWith("https://")) {
            this.sendRedirect(location, request, response);
        } else {
            this.sendServletRelativeRedirect(location, request, response);
        }
    }

    private void sendServletRelativeRedirect(String location, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer url = new StringBuffer(request.getContextPath());
        url.append(request.getServletPath());
        if (!location.startsWith("/")) {
            url.append('/');
        }
        url.append(location);
        this.sendRedirect(url.toString(), request, response);
    }

    private void sendRedirect(String url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(303);
        response.setHeader("Location", response.encodeRedirectURL(url));
    }

    protected MutableAttributeMap defaultFlowExecutionInputMap(HttpServletRequest request) {
        LocalAttributeMap inputMap = new LocalAttributeMap();
        Map parameterMap = request.getParameterMap();
        Iterator it = parameterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 1) {
                inputMap.put(name, (Object)values[0]);
                continue;
            }
            inputMap.put(name, (Object)values);
        }
        return inputMap;
    }
}

