/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.context.NormalModeSerializer;
import com.icesoft.faces.context.View;
import com.icesoft.faces.util.DOMUtils;
import com.icesoft.faces.webapp.command.Reload;
import com.icesoft.faces.webapp.command.UpdateElements;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.standard.NoCacheContentHandler;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PushModeSerializer
implements DOMSerializer {
    private Document oldDocument;
    private View view;
    private BridgeFacesContext context;
    private String viewNumber;

    public PushModeSerializer(Document currentDocument, View view, BridgeFacesContext context, String viewNumber) {
        this.oldDocument = currentDocument;
        this.view = view;
        this.context = context;
        this.viewNumber = viewNumber;
    }

    public void serialize(Document document) throws IOException {
        Node[] changed = DOMUtils.domDiff(this.oldDocument, document);
        HashMap<Integer, HashSet<Element>> depthMaps = new HashMap<Integer, HashSet<Element>>();
        for (int i = 0; i < changed.length; ++i) {
            Element changeRoot = DOMUtils.ascendToNodeWithID(changed[i]);
            changed[i] = changeRoot;
            Integer depth = new Integer(this.getDepth(changeRoot));
            HashSet<Element> peers = (HashSet<Element>)depthMaps.get(depth);
            if (null == peers) {
                peers = new HashSet<Element>();
                depthMaps.put(depth, peers);
            }
            peers.add(changeRoot);
        }
        Iterator allDepths = depthMaps.keySet().iterator();
        while (allDepths.hasNext()) {
            Integer baseDepth = (Integer)allDepths.next();
            Iterator checkDepths = depthMaps.keySet().iterator();
            while (checkDepths.hasNext()) {
                Integer checkDepth = (Integer)checkDepths.next();
                if (baseDepth >= checkDepth) continue;
                this.pruneAncestors(baseDepth, (HashSet)depthMaps.get(baseDepth), checkDepth, (HashSet)depthMaps.get(checkDepth));
            }
        }
        HashSet topElements = new HashSet();
        Iterator allDepthMaps = depthMaps.values().iterator();
        while (allDepthMaps.hasNext()) {
            topElements.addAll((HashSet)allDepthMaps.next());
        }
        if (!topElements.isEmpty()) {
            boolean reload = false;
            int j = 0;
            Element[] elements = new Element[topElements.size()];
            HashSet<Element> dupCheck = new HashSet<Element>();
            for (int i = 0; i < changed.length; ++i) {
                Element element = (Element)changed[i];
                String tag = element.getTagName();
                boolean bl = reload = reload || "html".equalsIgnoreCase(tag) || "head".equalsIgnoreCase(tag);
                if (!topElements.contains(element) || dupCheck.contains(element)) continue;
                dupCheck.add(element);
                elements[j++] = element;
            }
            if (reload) {
                this.view.preparePage(new PreparedPage(document));
                this.view.put(new Reload(this.viewNumber));
            } else {
                this.view.put(new UpdateElements(elements));
            }
        }
        this.oldDocument = document;
    }

    private void pruneAncestors(Integer parentDepth, Collection parents, Integer childDepth, Collection children) {
        Iterator parentList = parents.iterator();
        while (parentList.hasNext()) {
            Node parent = (Node)parentList.next();
            Iterator childList = children.iterator();
            while (childList.hasNext()) {
                Node child = (Node)childList.next();
                if (!this.isAncestor(parentDepth, parent, childDepth, child)) continue;
                childList.remove();
            }
        }
    }

    private int getDepth(Node node) {
        int depth = 0;
        Node parent = node;
        while ((parent = parent.getParentNode()) != null) {
            ++depth;
        }
        return depth;
    }

    private boolean isAncestor(Integer parentDepth, Node parent, Integer childDepth, Node child) {
        if (!parent.hasChildNodes()) {
            return false;
        }
        Node testParent = child;
        int stopDepth = parentDepth;
        for (int testDepth = childDepth.intValue(); (testParent = testParent.getParentNode()) != null && testDepth > stopDepth; --testDepth) {
            if (!testParent.equals(parent)) continue;
            return true;
        }
        return false;
    }

    private class PreparedPage
    extends NoCacheContentHandler {
        private final Document document;

        public PreparedPage(Document document) {
            super("text/html", "UTF-8");
            this.document = document;
        }

        public void respond(Response response) throws Exception {
            super.respond(response);
            OutputStreamWriter writer = new OutputStreamWriter(response.writeBody(), "UTF-8");
            NormalModeSerializer serializer = new NormalModeSerializer(PushModeSerializer.this.context, writer);
            serializer.serialize(this.document);
        }
    }
}

