/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticTimerUtility {
    private static int timerIndex;
    public static Log Log;
    private static int jobId;
    private static int totalTimerCount;
    private static long startTime;
    private static long timerStartTime;
    private static long timerAccumulatedTime;
    private static int timersCompleted;

    public static void newJob(int subJobCount) {
        if (!Log.isTraceEnabled()) {
            return;
        }
        if (subJobCount < 0) {
            throw new IllegalArgumentException("Timer count can't be < 0");
        }
        if (subJobCount == 0) {
            return;
        }
        if (jobId != 0) {
            Log.trace((Object)(" ==> Terminating job: " + jobId + " early, " + timersCompleted + " sub-jobs of " + totalTimerCount + " completed"));
        }
        Log.trace((Object)("============= New Timer Job with: " + subJobCount + " subjobs ==============="));
        jobId = ++timerIndex;
        totalTimerCount = subJobCount;
    }

    public static void startJobTmer() {
        startTime = System.nanoTime();
        timerAccumulatedTime = 0L;
    }

    public static void startSubjobTimer() {
        timerStartTime = System.nanoTime();
    }

    public static void subJobTimerComplete() {
        if (!Log.isTraceEnabled()) {
            return;
        }
        timerAccumulatedTime += System.nanoTime() - timerStartTime;
        if (++timersCompleted >= totalTimerCount) {
            Log.trace((Object)(" ==> Timer job: " + jobId + " containing: " + totalTimerCount + " subjobs" + ", elapsed real time: " + (float)(System.nanoTime() - startTime) / 1.0E9f + " seconds"));
            Log.trace((Object)("   ==> Timer job: " + jobId + " accumulated cpu time: " + (float)timerAccumulatedTime / 1.0E9f + " seconds"));
            Log.trace((Object)"============================");
            StaticTimerUtility.reset();
        }
    }

    private static void reset() {
        jobId = 0;
        timersCompleted = 0;
        totalTimerCount = 0;
        timerAccumulatedTime = 0L;
        startTime = 0L;
    }

    static {
        Log = LogFactory.getLog((Class)StaticTimerUtility.class);
    }
}

