/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.core.SendUpdatedViews;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.util.MonitorRunner;
import java.lang.reflect.Constructor;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncServerDetector
implements Server {
    private static final Log LOG = LogFactory.getLog((Class)AsyncServerDetector.class);
    private static final Object LOCK = new Object();
    private static ServerFactory factory;
    private static ServerFactory fallbackFactory;
    private Server server;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$com$icesoft$faces$webapp$http$core$ViewQueue;
    static /* synthetic */ Class class$com$icesoft$net$messaging$MessageServiceClient;
    static /* synthetic */ Class class$com$icesoft$faces$webapp$http$core$AsyncServerDetector$AsyncHttpServerAdaptingServletFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncServerDetector(String icefacesID, Collection synchronouslyUpdatedViews, ViewQueue allUpdatedViews, MonitorRunner monitorRunner, Configuration configuration, MessageServiceClient messageServiceClient) {
        if (factory == null) {
            Object object = LOCK;
            synchronized (object) {
                if (factory == null) {
                    boolean isAsyncHttpServiceAvailable = this.isAsyncHttpServiceAvailable();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Asynchronous HTTP Service available: " + isAsyncHttpServiceAvailable));
                    }
                    boolean isJMSAvailable = this.isJMSAvailable();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("JMS API available: " + isJMSAvailable));
                    }
                    if (isAsyncHttpServiceAvailable && configuration.getAttribute("blockingRequestHandler", configuration.getAttributeAsBoolean("async.server", true) ? "icefaces-ahs" : "icefaces").equalsIgnoreCase("icefaces-ahs") && isJMSAvailable) {
                        LOG.info((Object)"Adapting to Asynchronous HTTP Service environment.");
                        factory = new AsyncHttpServerAdaptingServletFactory();
                        fallbackFactory = new SendUpdatedViewsFactory();
                    } else {
                        LOG.info((Object)"Adapting to Send Updated Views environment.");
                        factory = new SendUpdatedViewsFactory();
                    }
                }
            }
        }
        this.server = factory.newServer(icefacesID, synchronouslyUpdatedViews, allUpdatedViews, monitorRunner, configuration, messageServiceClient);
    }

    public void service(Request request) throws Exception {
        this.server.service(request);
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private boolean isAsyncHttpServiceAvailable() {
        try {
            this.getClass().getClassLoader().loadClass("com.icesoft.faces.async.server.AsyncHttpServerAdaptingServlet");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private boolean isJMSAvailable() {
        try {
            this.getClass().getClassLoader().loadClass("javax.jms.TopicConnectionFactory");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private static class SendUpdatedViewsFactory
    implements ServerFactory {
        private SendUpdatedViewsFactory() {
        }

        public Server newServer(String icefacesID, Collection synchronouslyUpdatedViews, ViewQueue allUpdatedViews, MonitorRunner monitorRunner, Configuration configuration, MessageServiceClient messageServiceClient) {
            return new SendUpdatedViews(icefacesID, synchronouslyUpdatedViews, allUpdatedViews, monitorRunner, configuration);
        }
    }

    private static class AsyncHttpServerAdaptingServletFactory
    implements ServerFactory {
        private static Constructor constructor;

        private AsyncHttpServerAdaptingServletFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Server newServer(String icefacesID, Collection synchronouslyUpdatedViews, ViewQueue allUpdatedViews, MonitorRunner monitorRunner, Configuration configuration, MessageServiceClient messageServiceClient) {
            try {
                return (Server)constructor.newInstance(new Object[]{icefacesID, synchronouslyUpdatedViews, allUpdatedViews, messageServiceClient});
            }
            catch (Exception exception) {
                LOG.warn((Object)"Failed to adapt to Asynchronous HTTP Service environment. Falling back to Send Updated Views environment.", (Throwable)exception);
                Object object = LOCK;
                synchronized (object) {
                    factory = fallbackFactory;
                    fallbackFactory = null;
                }
                return factory.newServer(icefacesID, synchronouslyUpdatedViews, allUpdatedViews, monitorRunner, configuration, messageServiceClient);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            try {
                constructor = (class$com$icesoft$faces$webapp$http$core$AsyncServerDetector$AsyncHttpServerAdaptingServletFactory == null ? (class$com$icesoft$faces$webapp$http$core$AsyncServerDetector$AsyncHttpServerAdaptingServletFactory = AsyncServerDetector.class$("com.icesoft.faces.webapp.http.core.AsyncServerDetector$AsyncHttpServerAdaptingServletFactory")) : class$com$icesoft$faces$webapp$http$core$AsyncServerDetector$AsyncHttpServerAdaptingServletFactory).getClassLoader().loadClass("com.icesoft.faces.async.server.AsyncHttpServerAdaptingServlet").getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = AsyncServerDetector.class$("java.lang.String")) : class$java$lang$String, class$java$util$Collection == null ? (class$java$util$Collection = AsyncServerDetector.class$("java.util.Collection")) : class$java$util$Collection, class$com$icesoft$faces$webapp$http$core$ViewQueue == null ? (class$com$icesoft$faces$webapp$http$core$ViewQueue = AsyncServerDetector.class$("com.icesoft.faces.webapp.http.core.ViewQueue")) : class$com$icesoft$faces$webapp$http$core$ViewQueue, class$com$icesoft$net$messaging$MessageServiceClient == null ? (class$com$icesoft$net$messaging$MessageServiceClient = AsyncServerDetector.class$("com.icesoft.net.messaging.MessageServiceClient")) : class$com$icesoft$net$messaging$MessageServiceClient);
            }
            catch (Exception exception) {
                LOG.warn((Object)"Failed to adapt to Asynchronous HTTP Service environment. Falling back to Send Updated Views environment.", (Throwable)exception);
                Object object = LOCK;
                synchronized (object) {
                    factory = fallbackFactory;
                    fallbackFactory = null;
                }
            }
        }
    }

    private static interface ServerFactory {
        public Server newServer(String var1, Collection var2, ViewQueue var3, MonitorRunner var4, Configuration var5, MessageServiceClient var6);
    }
}

