/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.UIXhtmlComponent;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.DOMUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextRenderer
extends DomBasicInputRenderer {
    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
        this.validateParameters(facesContext, uiComponent, null);
    }

    protected void renderEnd(FacesContext facesContext, UIComponent uiComponent, String currentValue) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        if (this.isRenderingAsInput(uiComponent)) {
            this.renderUIInput(facesContext, uiComponent, currentValue);
        } else if (this.isRenderingAsOutput(uiComponent)) {
            this.renderUIOutput(facesContext, uiComponent, currentValue);
        }
    }

    protected boolean isRenderingAsInput(UIComponent uiComponent) {
        return uiComponent instanceof UIInput;
    }

    protected boolean isRenderingAsOutput(UIComponent uiComponent) {
        return uiComponent instanceof UIOutput;
    }

    private void renderUIOutput(FacesContext facesContext, UIComponent uiComponent, String currentValue) throws IOException {
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        boolean requiresContainingSpan = this.requiresContainingSpan(uiComponent);
        if (requiresContainingSpan) {
            this.renderContainingSpan(facesContext, uiComponent, domContext);
        } else {
            this.renderTextNode(domContext);
        }
        if (currentValue == null) {
            Text textNode = null;
            textNode = requiresContainingSpan ? (Text)domContext.getRootNode().getFirstChild() : (Text)domContext.getRootNode();
            if (textNode != null) {
                textNode.setData("");
            }
        } else {
            this.renderCurrentValue(uiComponent, currentValue, domContext, requiresContainingSpan);
        }
        domContext.streamWrite(facesContext, uiComponent);
    }

    private void renderTextNode(DOMContext domContext) {
        if (!domContext.isInitialized()) {
            Text root = domContext.getDocument().createTextNode("");
            domContext.setRootNode(root);
        } else if (!(domContext.getRootNode() instanceof Text)) {
            domContext.getRootNode().getParentNode().removeChild(domContext.getRootNode());
            domContext.setRootNode(domContext.getDocument().createTextNode(""));
        }
    }

    private void renderContainingSpan(FacesContext facesContext, UIComponent uiComponent, DOMContext domContext) {
        if (!domContext.isInitialized()) {
            Element root = domContext.createElement("span");
            domContext.setRootNode(root);
        } else if (!(domContext.getRootNode() instanceof Element)) {
            domContext.getRootNode().getParentNode().removeChild(domContext.getRootNode());
            domContext.setRootNode(domContext.createElement("span"));
        }
        Element rootSpan = (Element)domContext.getRootNode();
        TextRenderer.setRootElementId(facesContext, rootSpan, uiComponent);
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            rootSpan.setAttribute("class", styleClass);
        }
        PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null);
    }

    private void renderCurrentValue(UIComponent uiComponent, String currentValue, DOMContext domContext, boolean requiresContainingSpan) {
        boolean valueTextRequiresEscape = DOMUtils.escapeIsRequired(uiComponent);
        if (valueTextRequiresEscape) {
            currentValue = DOMUtils.escapeAnsi(currentValue);
        }
        Node rootNode = domContext.getRootNode();
        if (requiresContainingSpan) {
            domContext.setCursorParent(rootNode);
            if (rootNode.getFirstChild() != null && rootNode.getFirstChild() instanceof Text) {
                ((Text)rootNode.getFirstChild()).setData(currentValue);
            } else {
                Text text = domContext.getDocument().createTextNode(currentValue);
                rootNode.appendChild(text);
            }
        } else {
            ((Text)rootNode).setData(currentValue);
        }
    }

    private void renderUIInput(FacesContext facesContext, UIComponent uiComponent, String currentValue) throws IOException {
        Element root;
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            root = domContext.createElement("input");
            domContext.setRootNode(root);
            TextRenderer.setRootElementId(facesContext, root, uiComponent);
            root.setAttribute("type", "text");
            root.setAttribute("name", uiComponent.getClientId(facesContext));
        }
        root = (Element)domContext.getRootNode();
        String bidi = (String)uiComponent.getAttributes().get("dir");
        if (bidi != null) {
            root.setAttribute("dir", bidi);
        }
        if (currentValue != null) {
            root.setAttribute("value", currentValue);
        } else {
            root.removeAttribute("value");
        }
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        HashSet excludes = new HashSet();
        this.addJavaScript(facesContext, uiComponent, root, currentValue, excludes);
        PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, TextRenderer.getExcludesArray(excludes));
        String mousedownScript = root.getAttribute("onmousedown");
        mousedownScript = mousedownScript != null ? mousedownScript + ";this.focus();" : "this.focus();";
        root.setAttribute("onmousedown", mousedownScript);
        domContext.streamWrite(facesContext, uiComponent);
    }

    private boolean requiresContainingSpan(UIComponent uiComponent) {
        String tag;
        UIComponent parent = uiComponent.getParent();
        if (parent != null && parent instanceof UIXhtmlComponent && (tag = ((UIXhtmlComponent)parent).getTag()) != null && tag.equalsIgnoreCase("title")) {
            return false;
        }
        Boolean nospan = (Boolean)uiComponent.getAttributes().get("nospan");
        if (nospan != null && nospan.booleanValue()) {
            return false;
        }
        String style = (String)uiComponent.getAttributes().get("style");
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        String title = (String)uiComponent.getAttributes().get("title");
        if (styleClass != null || style != null || title != null) {
            return true;
        }
        Map attributes = uiComponent.getAttributes();
        if (attributes.size() != 0 && PassThruAttributeRenderer.passThruAttributeExists(uiComponent)) {
            return true;
        }
        return TextRenderer.idNotNull(uiComponent) && !uiComponent.getId().startsWith("_");
    }

    protected void addJavaScript(FacesContext facesContext, UIComponent uiComponent, Element root, String currentValue, HashSet excludes) {
    }
}

