/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.jsfcl.data;

import com.icesoft.faces.component.jsfcl.data.DefaultTree;
import com.icesoft.faces.component.tree.IceUserObject;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.swing.tree.DefaultMutableTreeNode;

public class NodeUserObject
extends IceUserObject {
    private DefaultTree treeBean;
    private static String nodeLabel;
    private String label;
    private static String nodeToolTip;

    public NodeUserObject(DefaultMutableTreeNode wrapper, DefaultTree treeBeanPointer) {
        super(wrapper);
        this.treeBean = treeBeanPointer;
        this.label = this.generateLabel();
        this.setLeafIcon("/xmlhttp/css/xp/css-images/tree_document.gif");
        this.setBranchContractedIcon("/xmlhttp/css/xp/css-images/tree_folder_close.gif");
        this.setBranchExpandedIcon("/xmlhttp/css/xp/css-images/tree_folder_open.gif");
        this.setText(this.label);
        this.setTooltip(nodeToolTip);
        this.setExpanded(true);
    }

    private String generateLabel() {
        return "Node " + new Integer(this.treeBean.getIncreasedLabelCount()).toString();
    }

    public boolean isRootNode() {
        return this.getWrapper().isRoot();
    }

    public void deleteNode(ActionEvent event) {
        ((DefaultMutableTreeNode)this.getWrapper().getParent()).remove(this.getWrapper());
    }

    public void copyNode(ActionEvent event) {
        DefaultMutableTreeNode clonedWrapper = new DefaultMutableTreeNode();
        NodeUserObject clonedUserObject = new NodeUserObject(clonedWrapper, this.treeBean);
        NodeUserObject originalUserObject = (NodeUserObject)((Object)this.getWrapper().getUserObject());
        clonedUserObject.setAction(originalUserObject.getAction());
        clonedUserObject.setBranchContractedIcon(originalUserObject.getBranchContractedIcon());
        clonedUserObject.setBranchExpandedIcon(originalUserObject.getBranchExpandedIcon());
        clonedUserObject.setExpanded(originalUserObject.isExpanded());
        clonedUserObject.setLeafIcon(originalUserObject.getLeafIcon());
        clonedUserObject.setTooltip(nodeToolTip);
        clonedWrapper.setUserObject((Object)clonedUserObject);
        this.getWrapper().insert(clonedWrapper, 0);
    }

    public void nodeClicked(ActionEvent event) {
        this.treeBean.setSelectedNode(this.label);
    }

    static {
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        ResourceBundle messages = ResourceBundle.getBundle("com.icesoft.faces.component.jsfcl.data.resources.messages", locale);
        try {
            if (messages != null) {
                nodeLabel = messages.getString("components.tree.node.title");
                nodeToolTip = messages.getString("components.tree.node.tooltip");
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

