/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.FileUploadTestCase;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class SizesTest
extends FileUploadTestCase {
    public void testFileUpload() throws IOException, FileUploadException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int add = 16;
        int num = 0;
        int i = 0;
        while (i < 16384) {
            if (++add == 32) {
                add = 16;
            }
            String header = "-----1234\r\nContent-Disposition: form-data; name=\"field" + num++ + "\"\r\n" + "\r\n";
            baos.write(header.getBytes("US-ASCII"));
            int j = 0;
            while (j < i) {
                baos.write((byte)j);
                ++j;
            }
            baos.write("\r\n".getBytes("US-ASCII"));
            i += add;
        }
        baos.write("-----1234--\r\n".getBytes("US-ASCII"));
        List fileItems = this.parseUpload(baos.toByteArray());
        Iterator fileIter = fileItems.iterator();
        add = 16;
        num = 0;
        int i2 = 0;
        while (i2 < 16384) {
            if (++add == 32) {
                add = 16;
            }
            FileItem item = (FileItem)fileIter.next();
            Assert.assertEquals((String)("field" + num++), (String)item.getFieldName());
            byte[] bytes = item.get();
            Assert.assertEquals((int)i2, (int)bytes.length);
            int j = 0;
            while (j < i2) {
                Assert.assertEquals((byte)((byte)j), (byte)bytes[j]);
                ++j;
            }
            i2 += add;
        }
        Assert.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    public void testFileSizeLimit() throws IOException, FileUploadException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        ServletFileUpload upload = new ServletFileUpload(new DiskFileItemFactory());
        upload.setFileSizeMax(-1L);
        MockHttpServletRequest req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        List fileItems = upload.parseRequest(req);
        Assert.assertEquals((int)1, (int)fileItems.size());
        FileItem item = (FileItem)fileItems.get(0);
        Assert.assertEquals((String)"This is the content of the file\n", (String)new String(item.get()));
        upload = new ServletFileUpload(new DiskFileItemFactory());
        upload.setFileSizeMax(40L);
        req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        fileItems = upload.parseRequest(req);
        Assert.assertEquals((int)1, (int)fileItems.size());
        item = (FileItem)fileItems.get(0);
        Assert.assertEquals((String)"This is the content of the file\n", (String)new String(item.get()));
        upload = new ServletFileUpload(new DiskFileItemFactory());
        upload.setFileSizeMax(30L);
        req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        try {
            upload.parseRequest(req);
            Assert.fail((String)"Expected exception.");
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            Assert.assertEquals((long)30L, (long)e.getPermittedSize());
        }
    }
}

