/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class DiskFileItemSerializeTest
extends TestCase {
    private static final String textContentType = "text/plain";
    private static final String fileContentType = "application/octet-stream";
    private static final int threshold = 16;

    public DiskFileItemSerializeTest(String name) {
        super(name);
    }

    public void testBelowThreshold() {
        byte[] testFieldValueBytes = this.createContentBytes(15);
        FileItem item = this.createFileItem(testFieldValueBytes);
        Assert.assertTrue((String)"Initial: in memory", (boolean)item.isInMemory());
        Assert.assertEquals((String)"Initial: size", (long)item.getSize(), (long)testFieldValueBytes.length);
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        try {
            FileItem newItem = (FileItem)this.serializeDeserialize(item);
            Assert.assertTrue((String)"Check in memory", (boolean)newItem.isInMemory());
            this.compareBytes("Check", testFieldValueBytes, newItem.get());
            this.compareFileItems(item, newItem);
        }
        catch (Exception e) {
            Assert.fail((String)("Error Serializing/Deserializing: " + e));
        }
    }

    public void testThreshold() {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        FileItem item = this.createFileItem(testFieldValueBytes);
        Assert.assertTrue((String)"Initial: in memory", (boolean)item.isInMemory());
        Assert.assertEquals((String)"Initial: size", (long)item.getSize(), (long)testFieldValueBytes.length);
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        try {
            FileItem newItem = (FileItem)this.serializeDeserialize(item);
            Assert.assertTrue((String)"Check in memory", (boolean)newItem.isInMemory());
            this.compareBytes("Check", testFieldValueBytes, newItem.get());
            this.compareFileItems(item, newItem);
        }
        catch (Exception e) {
            Assert.fail((String)("Error Serializing/Deserializing: " + e));
        }
    }

    public void testAboveThreshold() {
        byte[] testFieldValueBytes = this.createContentBytes(17);
        FileItem item = this.createFileItem(testFieldValueBytes);
        Assert.assertFalse((String)"Initial: in memory", (boolean)item.isInMemory());
        Assert.assertEquals((String)"Initial: size", (long)item.getSize(), (long)testFieldValueBytes.length);
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        try {
            FileItem newItem = (FileItem)this.serializeDeserialize(item);
            Assert.assertFalse((String)"Check in memory", (boolean)newItem.isInMemory());
            this.compareBytes("Check", testFieldValueBytes, newItem.get());
            this.compareFileItems(item, newItem);
        }
        catch (Exception e) {
            Assert.fail((String)("Error Serializing/Deserializing: " + e));
        }
    }

    private void compareFileItems(FileItem origItem, FileItem newItem) {
        Assert.assertTrue((String)"Compare: is in Memory", (origItem.isInMemory() == newItem.isInMemory() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Compare: is Form Field", (origItem.isFormField() == newItem.isFormField() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Compare: Field Name", (String)origItem.getFieldName(), (String)newItem.getFieldName());
        Assert.assertEquals((String)"Compare: Content Type", (String)origItem.getContentType(), (String)newItem.getContentType());
        Assert.assertEquals((String)"Compare: File Name", (String)origItem.getName(), (String)newItem.getName());
    }

    private void compareBytes(String text, byte[] origBytes, byte[] newBytes) {
        if (origBytes == null) {
            Assert.fail((String)(String.valueOf(text) + " origBytes are null"));
        }
        if (newBytes == null) {
            Assert.fail((String)(String.valueOf(text) + " newBytes are null"));
        }
        Assert.assertEquals((String)(String.valueOf(text) + " byte[] length"), (int)origBytes.length, (int)newBytes.length);
        int i = 0;
        while (i < origBytes.length) {
            Assert.assertEquals((String)(String.valueOf(text) + " byte[" + i + "]"), (byte)origBytes[i], (byte)newBytes[i]);
            ++i;
        }
    }

    private byte[] createContentBytes(int size) {
        StringBuffer buffer = new StringBuffer(size);
        int count = 0;
        int i = 0;
        while (i < size) {
            buffer.append(String.valueOf(count));
            count = (byte)(count + 1);
            if (count > 9) {
                count = 0;
            }
            ++i;
        }
        return buffer.toString().getBytes();
    }

    private FileItem createFileItem(byte[] contentBytes) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        String textFieldName = "textField";
        FileItem item = factory.createItem(textFieldName, textContentType, true, "My File Name");
        try {
            OutputStream os = item.getOutputStream();
            os.write(contentBytes);
            os.close();
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException" + e));
        }
        return item;
    }

    private Object serializeDeserialize(Object target) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(target);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Exception during serialization: " + e));
        }
        Object result = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = ois.readObject();
            bais.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Exception during deserialization: " + e));
        }
        return result;
    }
}

