/*
Copyright (c) 2011, David Linner <david.linner@tu-berlin.de>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

import javax.servlet.http.HttpServletRequest;

import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;

/**
 * Derived from Greg Wilkins example "Jetty WebSocket Server".
 * Passes messages on to all clients but the sender.
 *
 */
public class ForwardServlet extends WebSocketServlet {
	
	private static final long serialVersionUID = 1L;

	private final Set<ForwardWebSocket> members = new CopyOnWriteArraySet<ForwardWebSocket>();
    
//    protected void doGet(HttpServletRequest request, HttpServletResponse response) 
//        throws ServletException ,IOException {
//    	//getServletContext().getNamedDispatcher("default").forward(request, response);
//    	response.setStatus(101);
//    }
    
    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol)
    {
        return new ForwardWebSocket();
    }
    
    class ForwardWebSocket implements WebSocket.OnTextMessage
    {
    	protected Connection connection;    	

        public void onMessage(String data){
            for (ForwardWebSocket member : ForwardServlet.this.members){
            	if (member == this) continue;
                try{                
                	member.connection.sendMessage(data);
                } catch(IOException e) {
                	e.printStackTrace();
                }
            }
        }

		@Override
		public void onClose(int arg0, String arg1) {
			ForwardServlet.this.members.remove(this);
		}

		@Override
		public void onOpen(Connection connection) {
			this.connection = connection;		
			ForwardServlet.this.members.add(this);
		}		
    }

}
