package net.nieden.FileCrypter;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

public class CPasswdReader extends JFrame implements ActionListener, WindowListener, KeyListener {
	private static final long serialVersionUID = 1L;
	JPasswordField jfPasswd=new JPasswordField();
	JLabel jlPasswd=new JLabel("Password:");
	JButton jbOK=new JButton("OK"), jbCancel=new JButton("Cancel");
	Boolean finished=false;

	public CPasswdReader() throws Exception {
		Object[] ctrlList = {
			jlPasswd,  8, 16, 80, 24,
			jfPasswd, 90, 16,140, 24,
			jbOK,    240, 16, 80, 24,
			jbCancel,240, 44, 80, 24, null
		};
		setLayout(null);
		for (int i=0;ctrlList[i]!=null;i+=5) {
			getContentPane().add((JComponent)ctrlList[i]);
				((JComponent)ctrlList[i]).setBounds((int)ctrlList[i+1],(int)ctrlList[i+2],(int)ctrlList[i+3],(int)ctrlList[i+4]);
		}
		setType(Window.Type.UTILITY);
		setSize(380,120);
	    setLocationRelativeTo(null);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("Enter password");
		addWindowListener(this);
		jfPasswd.addKeyListener(this);
		jbOK.addActionListener(this);
		jbCancel.addActionListener(this);
		setVisible(true);
	}

	public void actionPerformed(ActionEvent evt) {
		if (evt.getSource()==jbCancel) {
			System.exit(1);
		}
		if (evt.getSource()==jbOK) {
			synchronized(finished) {
				finished=true;
				dispose();
			}
		}
	}

	public String readPasswd() {
		for (;;) {
			synchronized(finished) {
				if (finished) {
					return new String(jfPasswd.getPassword());
				}
			}
			try { Thread.sleep(100); } catch (Exception e) { }
		}
	}

	public void windowActivated(WindowEvent arg0) { }
	public void windowClosed(WindowEvent arg0) { }
	public void windowClosing(WindowEvent arg0) {
		synchronized(finished) {
			finished=true;
		}
	}
	public void windowDeactivated(WindowEvent arg0) { }
	public void windowDeiconified(WindowEvent arg0) { }
	public void windowIconified(WindowEvent arg0) { }
	public void windowOpened(WindowEvent arg0) { }

	public void keyPressed(KeyEvent arg0) { }
	public void keyReleased(KeyEvent arg0) {
		if (arg0.getKeyCode()==10) {
			synchronized(finished) {
				finished=true;
			}
			dispose();
		}
	}

	public void keyTyped(KeyEvent arg0) { 
	}
}
