package net.nieden.FileCrypter;

import java.awt.*;
import java.io.*;
import java.nio.*;
import java.security.spec.*;
import java.util.Date;
import java.util.zip.*;

import javax.crypto.*;
import javax.crypto.spec.*;
import javax.swing.*;
import javax.swing.table.DefaultTableModel;

import net.contrapunctus.lzma.LzmaOutputStream;

public class CFileTools {
	final static byte[] salt = {	// 8-byte Salt
		(byte)0xA9, (byte)0x9B, (byte)0xC8, (byte)0x32,
		(byte)0x56, (byte)0x35, (byte)0xE3, (byte)0x03
	};
	final static int iterationCount = 23;	// Iteration count

	public static byte[] readFromInputStream(InputStream is, int max) throws IOException {
		int nb, l;
		byte[] rb, buffer=new byte[max];

		for (nb=l=0;nb<max;nb+=l) {
			if ((l=is.read(buffer, nb, max-nb))<=0) break;
		}
		if (nb==0) return null;
		ByteBuffer bb=ByteBuffer.wrap(buffer,0,nb);
		bb.get((rb=new byte[nb]),0,nb);
		return rb;
	}

	public static void writeIntArray(int[] array, OutputStream os) throws IOException {
		for (int i: array) {
			os.write(i & 0xff);
		}
	}

	public static byte[] compressBlock(byte[] inputBlock) throws IOException {
		return compressBlock(inputBlock, false);
	}

	public static byte[] compressBlock(byte[] inputBlock, boolean is7zip) throws IOException {
		byte[] output=new byte[2*inputBlock.length];

		if (is7zip) {
			ByteArrayOutputStream bos;
			LzmaOutputStream lzOut=new LzmaOutputStream((bos=new ByteArrayOutputStream()));
			lzOut.write(inputBlock, 0, inputBlock.length);
			lzOut.flush();
			lzOut.close();
			return bos.toByteArray();
		} else {
			Deflater compresser = new Deflater(Deflater.BEST_COMPRESSION);
			compresser.setInput(inputBlock);
			compresser.finish();
			int cpl = compresser.deflate(output);
			ByteBuffer bb=ByteBuffer.allocate(cpl);
			return bb.put(output,0,cpl).array();
		}
	}

	public static byte[] decompressBlock(byte[] inputBlock) throws Exception {
		byte[] output=new byte[32*1024*1024];

		Inflater decompresser = new Inflater();
		decompresser.setInput(inputBlock, 0, inputBlock.length);
		int cpl = decompresser.inflate(output);
		decompresser.end();
		ByteBuffer bb=ByteBuffer.allocate(cpl);
		return bb.put(output,0,cpl).array();
	}

	public static byte[] encryptBlock(Cipher ecipher, byte[] inputBlock) throws IllegalBlockSizeException, BadPaddingException {
		return ecipher.doFinal(inputBlock);
	}

	public static byte[] decryptBlock(Cipher dcipher, byte[] inputBlock) throws IllegalBlockSizeException, BadPaddingException {
		return dcipher.doFinal(inputBlock);
	}
	
	public static String toHexDump(byte[] block) {
		return toHexDump(block, 0);
	}

	public static String toHexDump(byte[] block, int limit) {
		String s="";
		int l=(limit==0 || block.length<limit)?block.length:limit;
		int lines=(l/16)+((l%16)>0?1:0);
		for (int y=0;y<lines;y++) {
			int cols=((y+1)==lines && (block.length%16)>0)?(block.length%16):16;
			s+=String.format("%06x: ", y*16);
			for (int x=0;x<16;x++) {
				if (x>=cols) {
					s+="   ";
				} else s+=String.format("%02x ", (int)block[y*16+x]&0xff);
				if (x==7) s+="- ";
			}
			s+="\n";
		}
		return s;
	}

	public static void writeLengthToFile(int length, OutputStream os) throws Exception {
		for (int j=0;j<4;j++) {
			os.write((int)(length >>> ((3-j)*8))&0xff);
		}
		os.flush();
	}

	public static void longToByteArray(long lValue, byte[] bb, int pos, int length) {
		for (int i=0;i<length;i++) {
			int ch=(int)(lValue >>> ((3-i)*8))&0xff;
			bb[pos+i]=(byte)ch;
		}
	}

	public static void longToIntArray(long lValue, int[] bb, int pos, int length) {
		for (int i=0;i<length;i++) {
			int ch=(int)(lValue >>> (((length-1)-i)*8))&0xff;
			bb[pos+i]=ch;
		}
	}

	public static void intArrayToByteArray(int[] iArray, byte[] bArray, int pos) {
		for (int i=0;i<iArray.length;i++) {
			int ch=iArray[i] & 0xff;
			bArray[pos+i]=(byte)ch;
		}
	}

	public static long byteArrayToLong(byte[] bb, int pos, int length) {
		long l=0;
		
		for (int i=0;i<length;i++) {
			l<<=8; l|=bb[pos+i]&0xff;
		}
		return l;
	}

	public static int byteArrayToInt(byte[] bb, int pos, int length) {
		int i=0;
		
		for (int j=0;j<length;j++) {
			i<<=8; i|=bb[pos+j]&0xff;
		}
		return i;
	}

	public static Cipher initEncryption(String passwd) throws Exception {
		Cipher cipher;

		KeySpec keySpec = new PBEKeySpec(passwd.toCharArray(), salt, iterationCount);
		SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
		cipher = Cipher.getInstance(key.getAlgorithm());
		AlgorithmParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
		cipher.init(Cipher.ENCRYPT_MODE, key, paramSpec);
		return cipher;
	}

	public static Cipher initDecryption(String passwd) throws Exception {
		Cipher cipher;

		KeySpec keySpec = new PBEKeySpec(passwd.toCharArray(), salt, iterationCount);
		SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
		cipher = Cipher.getInstance(key.getAlgorithm());
		AlgorithmParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
		cipher.init(Cipher.DECRYPT_MODE, key, paramSpec);
		return cipher;
	}

	public static String printDottedNumber(long lNumber) {
		StringBuffer sb= new StringBuffer("   .   .   ");
		int[] ist = { 10,9,8,6,5,4,2,1,0 };
		for (int i=0;;i++) {
			sb.setCharAt(ist[i],(char)('0'+(lNumber % 10)));
			if ((lNumber/=10)==0) {
				for (int j=ist[i]-1;j>=0;j--)
					sb.setCharAt(j, ' ');
				break;
			}
		}
		return sb.toString();
	}

	public static boolean byteArrayCompare(byte[]a, byte[] b) {
		if (a.length!=b.length) return false;
		int i, l=a.length;
		
		for (i=0;i<l;i++)
			if (a[i]!=b[i]) return false;
		return true;
	}

	public static void setIconImageFromResource(JFrame jf, String sIconName) throws Exception {
		InputStream in = jf.getClass().getResourceAsStream("images/"+sIconName);
		if (in != null) {
			int n, total=0;
			byte[] buf=new byte[24000];
			try {
				while ((n=in.read(buf,total,buf.length-total))>0) {
					total+=n;
				}
			} catch (Exception e) {}
			byte[] bIcon=new byte[total];
			System.arraycopy(buf, 0, bIcon, 0, total);
			jf.setIconImage(Toolkit.getDefaultToolkit().createImage(bIcon));
		} else {
			jf.setIconImage(Toolkit.getDefaultToolkit().createImage("Images/"+sIconName));
		}
	}
	public static void initTable(JTable jt, String[] sColumnList, int maxRows, boolean bEdit) {
		initTable(jt, sColumnList, maxRows, bEdit, null);
	}

	public static void initTable(JTable jt, String[] sColumnList, int maxRows, boolean bEdit, Font font) {
		int	n=sColumnList.length;
		Object[][] objArray = new Object[maxRows][n];
		boolean[] bCanEdit = new boolean[n];
		@SuppressWarnings("rawtypes")
		Class[] cTypes = new Class[n];
		int[] iColSizeList = new int[n];
		String[] sColumnTextList = new String[n];
		for (int i=0;i<n;i++) {
			String[] sl=sColumnList[i].split(";");
			switch (sl[1].toUpperCase().charAt(0)) {
			case 'B': cTypes[i]=Boolean.class; break;
			case 'I': cTypes[i]=Integer.class; break;
			case 'S': cTypes[i]=String.class; break;
			case 'D': cTypes[i]=Date.class; break;
			default : cTypes[i]=String.class; break;
			}
			bCanEdit[i]=bEdit;
			if (sl.length>3) {
				bCanEdit[i]=sl[3].startsWith("1");
			}
			iColSizeList[i]=Integer.parseInt(sl[0]);
			sColumnTextList[i] = sl[2];
		}
		@SuppressWarnings("rawtypes")
		final Class[] types=cTypes.clone();
		final boolean[] canEdit = bCanEdit.clone();
		jt.removeAll();
		jt.setModel(new DefaultTableModel(objArray, sColumnTextList) { 
			private static final long serialVersionUID = 7L;
			@SuppressWarnings({ "unchecked", "rawtypes" })
			public Class getColumnClass(int i) { return types[i]; }
			public boolean isCellEditable(int i, int ci) { return canEdit[ci]; }
		});
		for (int i=0;i<n;i++) {
			jt.getColumnModel().getColumn(i).setMaxWidth(iColSizeList[i]);
			jt.getColumnModel().getColumn(i).setResizable(false);
		}
		if (font!=null) jt.setFont(font);
	}
}
