/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import SevenZip.Compression.LZMA.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;
import net.contrapunctus.lzma.ConcurrentBufferInputStream;
import net.contrapunctus.lzma.ConcurrentBufferOutputStream;

class EncoderThread
extends Thread {
    public static final Integer DEFAULT_DICT_SZ_POW2 = new Integer(0x100000);
    protected ArrayBlockingQueue<byte[]> q = ConcurrentBufferOutputStream.newQueue();
    protected InputStream in = ConcurrentBufferInputStream.create(this.q);
    protected OutputStream out;
    protected Encoder enc;
    protected IOException exn;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    EncoderThread(OutputStream outputStream) {
        this(outputStream, DEFAULT_DICT_SZ_POW2, null);
    }

    EncoderThread(OutputStream outputStream, Integer n, Integer n2) {
        this.out = outputStream;
        this.enc = new Encoder();
        this.exn = null;
        this.enc.SetDictionarySize(1 << (n == null ? DEFAULT_DICT_SZ_POW2 : n));
        if (n2 != null) {
            this.enc.SetNumFastBytes(n2);
        }
        if (DEBUG) {
            dbg.printf("%s << %s (%s)%n", this, this.in, this.q);
        }
    }

    public void run() {
        block4: {
            try {
                this.enc.SetEndMarkerMode(true);
                if (DEBUG) {
                    dbg.printf("%s begins%n", this);
                }
                this.enc.Code(this.in, this.out, -1L, -1L, null);
                if (DEBUG) {
                    dbg.printf("%s ends%n", this);
                }
                this.out.close();
            }
            catch (IOException iOException) {
                this.exn = iOException;
                if (!DEBUG) break block4;
                dbg.printf("%s exception: %s%n", this.exn.getMessage());
            }
        }
    }

    public String toString() {
        return String.format("Enc@%x", this.hashCode());
    }

    static {
        String string = null;
        try {
            string = System.getProperty("DEBUG_LzmaCoders");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = string != null;
    }
}

