/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Cipher;
import net.nieden.FileCrypter.CFileTools;

public class CFileHeader {
    static final int HDR_NETTO_SIZE = 26;
    static final int MAGIC_REGULAR = 171;
    static final int MAGIC_PASSWD = 172;
    static final int MAGIC_COMPRESS = 173;
    static final int MAGIC_PASSWD_COMPRESS = 174;
    int[] bMagicHdr = new int[]{158, 122, 171, 255};
    int[] bHdrSize = new int[2];
    int[] bBlockCountSize = new int[8];
    int[] bFileSizeAndDate = new int[12];
    byte[] cryptedFilename;
    byte[] md5Passwd = null;
    int blockCount;
    int blockSizeKB;
    int timeStamp;
    long originalFileSize;
    boolean compression;
    boolean storePasswd;
    String originalFileName;
    Date lastModified;

    public CFileHeader(int n, boolean bl, File file, Cipher cipher) throws Exception {
        this(n, bl, file, cipher, null);
    }

    public CFileHeader(int n, boolean bl, File file, Cipher cipher, String string) throws Exception {
        this.compression = bl;
        this.blockSizeKB = n;
        if (string != null) {
            this.bMagicHdr[2] = this.bMagicHdr[2] + 1;
        }
        if (bl) {
            this.bMagicHdr[2] = this.bMagicHdr[2] + 2;
        }
        this.originalFileSize = file.length();
        this.lastModified = new Date(file.lastModified());
        this.blockCount = (int)(this.originalFileSize / (long)(1024 * n));
        if (this.originalFileSize % (long)(1024 * n) > 0L) {
            ++this.blockCount;
        }
        CFileTools.longToIntArray(this.blockCount, this.bBlockCountSize, 0, 2);
        CFileTools.longToIntArray(n, this.bBlockCountSize, 2, 6);
        CFileTools.longToIntArray(file.length(), this.bFileSizeAndDate, 0, 8);
        this.timeStamp = (int)(file.lastModified() / 1000L);
        CFileTools.longToIntArray(this.timeStamp, this.bFileSizeAndDate, 8, 4);
        this.cryptedFilename = CFileTools.encryptBlock(cipher, file.getName().getBytes());
        CFileTools.longToIntArray(26 + this.cryptedFilename.length, this.bHdrSize, 0, 2);
        if (string != null) {
            this.md5Passwd = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        CFileTools.longToIntArray(string == null ? 0 : 42 + this.cryptedFilename.length, this.bHdrSize, 0, 2);
    }

    public CFileHeader(InputStream inputStream, Cipher cipher) throws Exception {
        this(inputStream, cipher, null);
    }

    public CFileHeader(InputStream inputStream, Cipher cipher, String string) throws Exception {
        byte[] byArray = new byte[26];
        inputStream.read(byArray, 0, byArray.length);
        if ((byArray[0] & 0xFF) != 158 || (byArray[1] & 0xFF) != 122 || (byArray[3] & 0xFF) != 255) {
            throw new Exception(String.format("Invalid Header-Magic: %02x %02x %02x %02x", byArray[0] & 0xFF, byArray[1] & 0xFF, byArray[2] & 0xFF, byArray[3] & 0xFF));
        }
        if ((byArray[2] & 0xFF) == 171) {
            this.compression = false;
            this.storePasswd = false;
        } else if ((byArray[2] & 0xFF) == 172) {
            this.compression = false;
            this.storePasswd = true;
        } else if ((byArray[2] & 0xFF) == 173) {
            this.compression = true;
            this.storePasswd = false;
        } else if ((byArray[2] & 0xFF) == 174) {
            this.compression = true;
            this.storePasswd = true;
        } else {
            throw new Exception("Invalid Header-Compression state!");
        }
        int n = CFileTools.byteArrayToInt(byArray, 4, 2);
        this.blockCount = CFileTools.byteArrayToInt(byArray, 6, 2);
        this.blockSizeKB = CFileTools.byteArrayToInt(byArray, 8, 6);
        this.originalFileSize = CFileTools.byteArrayToLong(byArray, 14, 8);
        this.timeStamp = CFileTools.byteArrayToInt(byArray, 22, 4);
        this.lastModified = new Date(1000L * (long)this.timeStamp);
        int n2 = n - 26;
        if (this.storePasswd) {
            n2 -= 16;
        }
        this.cryptedFilename = new byte[n2];
        inputStream.read(this.cryptedFilename, 0, n2);
        if (this.storePasswd) {
            byte[] byArray2;
            this.md5Passwd = new byte[16];
            inputStream.read(this.md5Passwd, 0, this.md5Passwd.length);
            if (string != null && !CFileTools.byteArrayCompare(byArray2 = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8")), this.md5Passwd)) {
                int n3;
                String string2 = "";
                for (n3 = 0; n3 < 16; ++n3) {
                    string2 = string2 + String.format("%02x ", byArray2[n3] & 0xFF);
                }
                string2 = string2 + "\n";
                for (n3 = 0; n3 < 16; ++n3) {
                    string2 = string2 + String.format("%02x ", this.md5Passwd[n3] & 0xFF);
                }
                System.err.println(string2);
                throw new Exception("Password given does not match password with which this file has been encrypted!");
            }
        }
        this.originalFileName = new String(CFileTools.decryptBlock(cipher, this.cryptedFilename));
    }

    public String toString() {
        return String.format("[%c] %s%14s %s", Character.valueOf(this.compression ? (char)'+' : '-'), new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(this.lastModified), CFileTools.printDottedNumber(this.originalFileSize), this.originalFileName);
    }

    public void writeHdr(OutputStream outputStream) throws Exception {
        byte[] byArray = new byte[26];
        CFileTools.intArrayToByteArray(this.bMagicHdr, byArray, 0);
        CFileTools.intArrayToByteArray(this.bHdrSize, byArray, 4);
        CFileTools.intArrayToByteArray(this.bBlockCountSize, byArray, 6);
        CFileTools.intArrayToByteArray(this.bFileSizeAndDate, byArray, 14);
        outputStream.write(byArray, 0, byArray.length);
        outputStream.write(this.cryptedFilename, 0, this.cryptedFilename.length);
        if (this.md5Passwd != null) {
            outputStream.write(this.md5Passwd, 0, this.md5Passwd.length);
        }
        outputStream.flush();
    }
}

