/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;
import javax.crypto.Cipher;
import net.nieden.FileCrypter.CFileBlockProcessor;
import net.nieden.FileCrypter.CFileHeader;
import net.nieden.FileCrypter.CFileTools;
import net.nieden.FileCrypter.IFileProcessInterrupter;
import net.nieden.FileCrypter.IFileProgressIndicator;

public class CFileEncrypter
implements IFileProcessInterrupter {
    private int blocks2Go;
    private int bufSizeKB;
    private IFileProgressIndicator pgrsIndicator = null;
    private File iFile;
    private boolean compression = false;
    private boolean multiThreaded = false;
    private boolean storePasswd = false;
    private boolean is7zip = false;
    Boolean canceled = false;
    private String passwd;
    private Cipher ecipher;

    public CFileEncrypter(File file, int n, String string) throws Exception {
        this.bufSizeKB = n;
        this.passwd = string;
        this.multiThreaded = false;
        this.blocks2Go = (int)file.length() / (n * 1024);
        if (file.length() % (long)(n * 1024) > 0L) {
            ++this.blocks2Go;
        }
        this.iFile = file;
        this.ecipher = CFileTools.initEncryption(string);
    }

    public void processFile() throws Exception {
        byte[] byArray;
        if (this.canceled.booleanValue()) {
            return;
        }
        CFileBlockProcessor cFileBlockProcessor = null;
        FileInputStream fileInputStream = new FileInputStream(this.iFile);
        String string = String.format("ENCRY_%012x.bin", new Date().getTime());
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        CFileHeader cFileHeader = new CFileHeader(this.bufSizeKB, this.compression, this.iFile, this.ecipher, this.storePasswd ? this.passwd : null);
        cFileHeader.writeHdr(fileOutputStream);
        if (this.multiThreaded) {
            cFileBlockProcessor = new CFileBlockProcessor(this.blocks2Go, true, this.pgrsIndicator);
        }
        for (int i = 0; i < this.blocks2Go && (byArray = CFileTools.readFromInputStream(fileInputStream, this.bufSizeKB * 1024)) != null; ++i) {
            if (this.multiThreaded) {
                while (!this.canceled.booleanValue()) {
                    int n = cFileBlockProcessor.getWorkingThreadCount();
                    if (n < cFileBlockProcessor.maxThreads) {
                        cFileBlockProcessor.blockProcThreadList.get(i).startWorking(byArray, this.compression, this.is7zip, this.passwd, fileOutputStream);
                        break;
                    }
                    Thread.sleep(100L);
                }
            } else {
                if (this.canceled.booleanValue()) break;
                if (this.compression) {
                    byArray = CFileTools.compressBlock(byArray, this.is7zip);
                }
                byte[] byArray2 = CFileTools.encryptBlock(this.ecipher, byArray);
                CFileTools.writeLengthToFile(byArray2.length, fileOutputStream);
                fileOutputStream.write(byArray2, 0, byArray2.length);
                if (this.canceled.booleanValue() || this.pgrsIndicator != null && !this.pgrsIndicator.progressIndicator(i, this.blocks2Go)) break;
            }
            if (this.canceled.booleanValue()) break;
        }
        fileInputStream.close();
        if (!this.canceled.booleanValue() && this.multiThreaded) {
            cFileBlockProcessor.waitForLastBlock();
        }
        fileOutputStream.close();
        if (this.canceled.booleanValue()) {
            new File(string).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        Boolean bl = this.canceled;
        synchronized (bl) {
            this.canceled = true;
        }
    }

    public int getNumberOfBlocksToProcess() {
        return this.blocks2Go;
    }

    public void setCompression(boolean bl) {
        this.setCompression(bl, false);
    }

    public void setCompression(boolean bl, boolean bl2) {
        this.compression = bl;
        this.is7zip = bl2;
    }

    public void setMultiThreaded(boolean bl) {
        this.multiThreaded = bl;
    }

    public void setStorePasswd(boolean bl) {
        this.storePasswd = bl;
    }

    public void setProgressIndicator(IFileProgressIndicator iFileProgressIndicator) {
        this.pgrsIndicator = iFileProgressIndicator;
    }
}

