/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import javax.crypto.Cipher;
import javax.swing.JOptionPane;
import net.nieden.FileCrypter.CFileCrypterGUI;
import net.nieden.FileCrypter.CFileDecrypter;
import net.nieden.FileCrypter.CFileEncrypter;
import net.nieden.FileCrypter.CFileHeader;
import net.nieden.FileCrypter.CFileTools;
import net.nieden.FileCrypter.CPasswdReader;
import net.nieden.FileCrypter.IFileProgressIndicator;

public class CFileCrypter
implements IFileProgressIndicator {
    static final int OPT_BUFSZ_FLS = 0;
    static final int OPT_COMPRESS = 1;
    static final int OPT_DECRYPTION = 2;
    static final int OPT_ENCRYPTION = 3;
    static final int OPT_LIST = 4;
    static final int OPT_MULTITHREAD = 5;
    static final int OPT_PASSWD_FLS = 6;
    static final int OPT_REMOVE = 7;
    static final int OPT_STOREPWD = 8;
    static final int OPT_VERBOSE = 9;
    static final int DEFAULT_BUFSZ_KB = 1024;
    static final int MAX_BUFSZ_KB = 32768;
    int opCount = 0;
    BitSet bsOption = new BitSet();
    String passWord = "";
    String options = "bcdelmprsv";
    ArrayList<File> fileList = new ArrayList();
    long timerStart;
    int bufSizeKB = 1024;

    public CFileCrypter(String[] stringArray) throws Exception {
        String string;
        Object object = stringArray;
        int n = ((String[])object).length;
        block4: for (int i = 0; i < n; ++i) {
            String string2 = object[i];
            if (string2.startsWith("-") && string2.length() > 1) {
                boolean bl = false;
                for (int j = 1; j < string2.length(); ++j) {
                    int n2 = this.options.indexOf(string2.charAt(j));
                    if (n2 < 0) {
                        this.usage(true);
                    }
                    switch (n2) {
                        case 0: {
                            if (j + 1 < string2.length()) {
                                this.bufSizeKB = Integer.parseInt(string2.substring(j + 1));
                            } else {
                                this.bsOption.set(n2);
                            }
                            bl = true;
                            break;
                        }
                        case 6: {
                            if (j + 1 < string2.length()) {
                                this.passWord = string2.substring(j + 1);
                            } else {
                                this.bsOption.set(n2);
                            }
                            bl = true;
                            break;
                        }
                        default: {
                            this.bsOption.set(n2);
                        }
                    }
                    if (bl) continue block4;
                }
                continue;
            }
            if (this.bsOption.get(0)) {
                this.bufSizeKB = Integer.parseInt(string2);
                this.bsOption.clear(0);
                continue;
            }
            if (this.bsOption.get(6)) {
                this.passWord = string2;
                this.bsOption.clear(6);
                continue;
            }
            File file = new File(string2);
            if (!file.isFile()) {
                throw new Exception(string2 + " is not a valid filename!");
            }
            this.fileList.add(file);
        }
        if (this.bsOption.get(3)) {
            ++this.opCount;
        }
        if (this.bsOption.get(2)) {
            ++this.opCount;
        }
        if (this.bsOption.get(4)) {
            ++this.opCount;
        }
        if (this.opCount != 1) {
            this.usage("Must specify exactly e(ncryption), d(ecryption) or l(ist) ...", true);
        }
        if (this.bufSizeKB < 1 || this.bufSizeKB > 32768) {
            this.usage("Illegal BufferSize in KB specified (Must be >= 1 <= 32768", true);
        }
        if (this.fileList.isEmpty()) {
            this.usage("Must specify at least one valid file!", true);
        }
        if (this.passWord.isEmpty() && ((string = ((CPasswdReader)(object = new CPasswdReader())).readPasswd()) == null || string.isEmpty())) {
            JOptionPane.showMessageDialog(null, "Empty password - exiting", "Error", 0);
            System.exit(1);
        }
        if (this.bufSizeKB != 1024 && this.bsOption.get(9)) {
            System.out.printf("Setting buffer Size to %d KB\n", this.bufSizeKB);
        }
    }

    public void processFileList() throws Exception {
        this.timerStart = new Date().getTime();
        for (File file : this.fileList) {
            Object object;
            if (this.bsOption.get(3)) {
                object = new CFileEncrypter(file, this.bufSizeKB, this.passWord);
                ((CFileEncrypter)object).setProgressIndicator(this);
                ((CFileEncrypter)object).setCompression(this.bsOption.get(1));
                ((CFileEncrypter)object).setMultiThreaded(this.bsOption.get(5));
                ((CFileEncrypter)object).setStorePasswd(this.bsOption.get(8));
                ((CFileEncrypter)object).processFile();
            } else if (this.bsOption.get(2)) {
                object = new CFileDecrypter(file, this.passWord);
                ((CFileDecrypter)object).processFile();
            } else {
                object = CFileTools.initDecryption(this.passWord);
                CFileHeader cFileHeader = new CFileHeader(new FileInputStream(file), (Cipher)object);
                System.out.println(cFileHeader);
            }
            if (!this.bsOption.get(7)) continue;
            file.delete();
        }
        long l = new Date().getTime() - this.timerStart;
        if (this.bsOption.get(9) && this.bsOption.get(3)) {
            System.out.printf("Operation completed in %02d:%02d.%03d\n", l / 60000L, l % 60000L / 1000L, l % 1000L);
        }
    }

    public void usage() {
        this.usage(null, false);
    }

    public void usage(boolean bl) {
        this.usage(null, bl);
    }

    public void usage(String string) {
        this.usage(string, false);
    }

    public void usage(String string, boolean bl) {
        if (string != null) {
            System.err.println(string);
        }
        System.err.println("usage: java " + CFileCrypter.class.getName() + " -options file ...");
        System.err.println("valid options are:");
        System.err.println("\t-b Blocksize in KB [1-32.768]");
        System.err.println("\t-c = compress (GZIP) before encryption");
        System.err.println("\t-d = decrpyt");
        System.err.println("\t-e = encrypt");
        System.err.println("\t-l = list original file data");
        System.err.println("\t-m = use multithread mechanism");
        System.err.println("\t-p password (En-/Decryption salt key)");
        System.err.println("\t-r = remove Source File after processing");
        System.err.println("\t-s = store password (not recommended)");
        System.err.println("\t-v = verbose operation");
        if (bl) {
            System.exit(1);
        }
    }

    @Override
    public boolean progressIndicator(int n, int n2) {
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                new CFileCrypterGUI();
            } else {
                CFileCrypter cFileCrypter = new CFileCrypter(stringArray);
                cFileCrypter.processFileList();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

