/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Enumeration;
import java.util.concurrent.Semaphore;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CDirChooser
implements ActionListener,
TreeSelectionListener,
MouseListener,
WindowListener {
    protected JDialog jf = new JDialog((Frame)null, "Select a directory", true);
    protected File rootDir;
    protected DefaultMutableTreeNode dmtRoot = new DefaultMutableTreeNode("/");
    protected JTree jt = new JTree(this.dmtRoot);
    protected JScrollPane jsp = new JScrollPane(this.jt, 22, 30);
    protected Semaphore semClose = new Semaphore(1);
    protected JMenuItem jmiSelect;
    protected JMenuItem jmiClose;
    protected JPopupMenu popup = new JPopupMenu();
    protected boolean isClosed = false;
    protected String sPathSelected = "";
    protected Image img = Toolkit.getDefaultToolkit().createImage("images/user-home.png");

    public CDirChooser(File file) throws Exception {
        if (!file.isDirectory()) {
            throw new Exception(file + " is not a valid directory!");
        }
        this.rootDir = file;
        this.buildGUI();
    }

    public String treePathToAbsolutePath(TreePath treePath) {
        String string = "";
        int n = treePath.getPathCount();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 1; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(i);
            if (i > 1 && string.charAt(string.length() - 1) != File.separatorChar) {
                string = string + File.separatorChar;
            }
            string = string + (String)defaultMutableTreeNode.getUserObject();
        }
        return string;
    }

    public void showSubDirsOfPath(TreePath treePath) {
        try {
            int n = treePath.getPathCount();
            String string = "";
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            for (int i = 1; i < n; ++i) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(i);
                if (i > 1 && string.charAt(string.length() - 1) != File.separatorChar) {
                    string = string + File.separatorChar;
                }
                string = string + (String)defaultMutableTreeNode.getUserObject();
            }
            File file = new File(string);
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    if (!file2.isDirectory()) continue;
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(file2.getName()));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isPathSelected() {
        this.waitForWindowClosed();
        return !this.sPathSelected.isEmpty();
    }

    public String getPathSelected() {
        this.waitForWindowClosed();
        return this.sPathSelected;
    }

    private void waitForWindowClosed() {
        try {
            while (true) {
                this.semClose.acquire();
                boolean bl = this.isClosed;
                this.semClose.release();
                if (bl) {
                    return;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildGUI() throws Exception {
        void var4_6;
        DefaultMutableTreeNode defaultMutableTreeNode;
        this.jf.setSize(400, 600);
        this.jf.setLayout(new GridLayout(1, 1));
        this.jf.getContentPane().add(this.jsp);
        this.jf.setLocationRelativeTo(null);
        this.jt.setExpandsSelectedPaths(true);
        this.jmiSelect = new JMenuItem("Select current entry and close this dialog");
        this.popup.add(this.jmiSelect);
        this.jmiClose = new JMenuItem("Close this dialog (no selection)");
        this.popup.add(this.jmiClose);
        this.jmiSelect.addActionListener(this);
        this.jmiClose.addActionListener(this);
        char c = File.separatorChar;
        String[] stringArray = this.rootDir.getAbsolutePath().split(String.format("\\%c", c));
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.dmtRoot;
        File[] object = File.listRoots();
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            File file = object[i];
            defaultMutableTreeNode = new DefaultMutableTreeNode(file.getAbsolutePath());
            this.dmtRoot.add(defaultMutableTreeNode);
            if (stringArray[0].charAt(0) != file.getAbsolutePath().charAt(0)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode;
        }
        Object var4_5 = null;
        for (n = 1; n < stringArray.length; ++n) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.children();
            boolean bl = false;
            defaultMutableTreeNode = null;
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!defaultMutableTreeNode.getUserObject().equals(stringArray[n])) continue;
                bl = true;
                break;
            }
            DefaultMutableTreeNode defaultMutableTreeNode3 = bl ? defaultMutableTreeNode : new DefaultMutableTreeNode(stringArray[n]);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            TreePath treePath = new TreePath(defaultMutableTreeNode3.getPath());
            this.jt.setSelectionPath(treePath);
            this.showSubDirsOfPath(treePath);
        }
        this.jt.scrollPathToVisible((TreePath)var4_6);
        this.jt.addTreeSelectionListener(this);
        this.jt.addMouseListener(this);
        this.jf.setDefaultCloseOperation(2);
        this.jf.addWindowListener(this);
        this.jf.setIconImage(this.img);
        this.jf.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.jmiClose) {
            this.jf.dispose();
            return;
        }
        if (actionEvent.getSource() == this.jmiSelect) {
            this.sPathSelected = this.treePathToAbsolutePath(this.jt.getSelectionPath());
            this.jf.dispose();
            return;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        this.showSubDirsOfPath(treePath);
    }

    public void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() == this.jt) {
            this.popup.show(this.jt, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        try {
            this.semClose.acquire();
            this.isClosed = true;
            this.semClose.release();
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

