import java.io.*;
import java.util.*;
import java.net.*;

public class JGetURL {
	URL u;
	BufferedReader br;

	public JGetURL(String urlStr) throws Exception {
		u=new URL(urlStr);
		br=new BufferedReader(new InputStreamReader(u.openStream()));
	}

	public String readHtmlDocument() throws IOException {
		String s="", sLine;

		while ((sLine=br.readLine())!=null) {
			s+=(sLine.trim()+"\r\n");
		}
		return s;
	}

	public static void main(String[] args) {
		if (args.length == 0) {
			System.err.println("usage: java "+JGetURL.class.getName()+" URL ...");
			System.exit(1);
		}
		try {
			for (String s: args) {
				JGetURL jgu=new JGetURL(s);
				String docStr=jgu.readHtmlDocument();
				System.out.println(docStr);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
