import java.io.*;
import java.net.*;

public class HttpSocket extends Socket {
	final static int MAX_HTML_DOC_LENGTH=5*1024*1024;
	String hostname;
	InputStream is;
	OutputStream os;
	private String[] documentLineList;
	private int documentLinePos=0;

	public HttpSocket(String hostname, int port) throws UnknownHostException, IOException {
		super(hostname, port);
		this.hostname=hostname;
		is=getInputStream();
		os=getOutputStream();
	}

	public String readDocument(String document) throws Exception {
		int cl=0;
		boolean isRedirect=false;
		String str, request=String.format("GET %s HTTP/1.1\r\nHost: %s\r\nUser-Agent: %s\r\nAccept: text/html\r\nConnection: close\r\n\r\n",
			document, hostname, CGetURL.class.getSimpleName());
		os.write(request.getBytes());
		BufferedReader br=new BufferedReader(new InputStreamReader(is));
		while ((str=br.readLine())!=null) {
			if (str.isEmpty()) {
				break;
			}
			if (str.startsWith("HTTP")) {
				String[] sList=str.split(" ");
				if (sList.length < 2) throw new Exception("Invalid Return Value");
				int code=Integer.parseInt(sList[1]);
				switch (code) {
					case 200: // ok
						break;
					case 301:
					case 302:
						isRedirect=true;
						break;
					default: if (code >= 400) {
							throw new Exception("HTTP Error "+code);
						}
						break;
				}
				continue;
			}
			if (str.startsWith("Content-Length:")) {
				cl=Integer.parseInt(str.substring(15).trim());
				continue;
			}
			if (isRedirect && str.startsWith("Location:")) {
				return str;
			}
		}
		if (cl > 0) {
			byte[] b=new byte[cl];
			
			int l, pos;
			for (pos=0;pos<cl;pos+=l) {
				if ((l=is.read(b,pos,cl-pos))<=0) {
					throw new Exception("Unexpected EOF reading from socket!");
				}
			}
			return new String(b);
		}
		int l, pos;
		cl=MAX_HTML_DOC_LENGTH;
		byte[] b=new byte[cl];
		for (pos=0;;pos+=l) {
			if ((l=is.read(b,pos,cl-pos))<=0) {
				throw new Exception("Unexpected EOF reading from socket!");
			}
			pos+=l;
			String s=new String(b,0,pos);
			if (s.contains("</html>")) break;
			if (pos>=MAX_HTML_DOC_LENGTH)
				throw new Exception("Document length exceeds MAX_HTML_DOC_LENGTH["+MAX_HTML_DOC_LENGTH+"]");
		}
		return new String(b,0,pos);
	}
}
