package de.accso.java8samples.beispiel5.parallelisierung.c_sum_skaliert;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Random;
import java.util.function.IntUnaryOperator;

public class Beispiel5c_sum {
    private static final int ARRAY_SIZE = 40000;

    public static void main(String[] args) {
        // Anlegen und Befuellen eines Arrays
        final int[] array = createRandomArray(ARRAY_SIZE);
        // Definition einer (langandauernden) Operation “wasteTime”
        final IntUnaryOperator op= ( n-> { wasteTime(n%10000); return n%100; });
        // Hilfsklasse auf Basis von java.time.*
        final Timer timer=new Timer();
        // Parallele Ausfuehrung
        timer.start();
        int resPar      = Arrays.stream(array).parallel().map(op).sum();
        Duration durPar = timer.getDuration();
        // Sequentielle Ausfuehrung
        timer.start();
        int resSeq      = Arrays.stream(array).map(op).sum();
        Duration durSeq = timer.getDuration();

        System.out.println("Result (sequential computation): " + resSeq + " (computation time: " + durSeq + ")");
        System.out.println("Result (parallel computation):   " + resPar + " (computation time: " + durPar + ")");
        System.out.println("Speedup: " + (double) durSeq.toMillis() / durPar.toMillis());
    }

    private static int[] createRandomArray(int size) {
        int[] array = new int[size];
        Random rnd = new Random();

        for (int i = 0; i < size; i++) {
            array[i] = rnd.nextInt(999_999_999);
        }

        return array;
    }

    private static double wasteTime(int max) {
        double d = 1;
        for (int i = 0; i < max; i++) {
            d *= Math.abs(Math.cos(d) * Math.sin(d));
        }
        return d;
    }

    private static class Timer {
        private Clock clock = Clock.systemUTC();
        private Instant startTime;

        public void start() {
            startTime = clock.instant();
        }

        public Duration getDuration() {
            return Duration.between(startTime, clock.instant());
        }
    }
}

