﻿using System;
using System.Collections.Generic;
using WWWings_GL;
using System.IO;
using System.Web;
using System.Reflection;

namespace WWWings_Services
{
  /// <summary>
  /// Dienstimplementierug
  /// </summary>
  public class WWWingsBuchungsservice : IWWWingsBuchungsservice, IDisposable
  {
    #region IWWWingsBuchungsservice Members

    BuchungsManager bm = new BuchungsManager();

    public WWWings_GO.Flug GetFlug(int FlugID)
    {
      return bm.GetFlug(FlugID);
    }

    public WWWings_GO.Passagier GetPassagier(int PassagierID)
    {
      return bm.GetPassagier(PassagierID);
    }

    public List<WWWings_GO.Flug> GetFluege(string Abflugort, string Zielort)
    {
      return bm.GetFluege(Abflugort, Zielort);
    }

    public List<WWWings_GO.Passagier> GetPassagiere(string Name)
    {
      return bm.GetPassagiere(Name);
    }

    public string SavePassagierSet(List<WWWings_GO.Passagier> PassagierSet)
    {
      return bm.SavePassagierSet(PassagierSet);
    }

    public string CreateBuchung(int FlugID, int PassagierID)
    {

      return bm.CreateBuchung(FlugID, PassagierID);
    }

    public List<string> GetFlughäfen()
    {
      return bm.GetFlughäfen();
    }

    #endregion

    #region IDisposable Members

    public void Dispose()
    {
      bm.Dispose();
    }

    #endregion


    public System.IO.Stream GetPicture(string stadt)
    {
      string pfad =Path.Combine( Path.GetDirectoryName( new Uri(Assembly.GetExecutingAssembly().CodeBase).AbsolutePath),"Bilder\\" + stadt.Replace('/', ' ') + ".jpg");
      pfad = HttpUtility.UrlDecode(pfad);
      return new FileStream(pfad, FileMode.Open, FileAccess.Read);
    }
  }
}
