﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using WWWings_GUI_SL5.Utilities;
using WWWings_GUI_SL5.WWWingsBuchungsserviceProxy;
using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace WWWings_GUI_SL5.ViewModels
{
  public class PassagierauswahlViewModel : ViewModelBase
  {
    public ActionCommand PassagierlisteLadenCommand { get; set; }

    public PassagierauswahlViewModel()
    {
      wwwingsBuchungsserviceProxy.GetPassagierCompleted += new EventHandler<WWWingsBuchungsserviceProxy.GetPassagierCompletedEventArgs>(wwwingsBuchungsserviceProxy_GetPassagierCompleted);
      wwwingsBuchungsserviceProxy.GetPassagiereCompleted += new EventHandler<WWWingsBuchungsserviceProxy.GetPassagiereCompletedEventArgs>(wwwingsBuchungsserviceProxy_GetPassagiereCompleted);
   
      PassagierlisteLadenCommand = new ActionCommand(PassagierlisteLaden) { IsEnabled = false };

    }

    void wwwingsBuchungsserviceProxy_GetPassagiereCompleted(object sender, WWWingsBuchungsserviceProxy.GetPassagiereCompletedEventArgs e)
    {
      Passagierliste = e.Result;
    }

    void wwwingsBuchungsserviceProxy_GetPassagierCompleted(object sender, WWWingsBuchungsserviceProxy.GetPassagierCompletedEventArgs e)
    {
      if (e.Result == null)
        Passagierliste = new ObservableCollection<Passagier>();
      else
        Passagierliste = new ObservableCollection<Passagier>() { e.Result };
    }

    private ObservableCollection<Passagier> passagierliste;

    public ObservableCollection<Passagier> Passagierliste
    {
      get { return passagierliste; }
      set { passagierliste = value; OnPropertyChanged("Passagierliste"); }
    }

    private Passagier ausgewählterPassagier;

    public Passagier AusgewählterPassagier
    {
      get { return ausgewählterPassagier; }
      set
      {
        ausgewählterPassagier = value; OnPropertyChanged("AusgewählterPassagier");
        IsValid = ausgewählterPassagier != null;
      }
    }

    private string nameOderID;

    public string NameOderID
    {
      get { return nameOderID; }
      set
      {
        nameOderID = value; OnPropertyChanged("NameOderID");
        PassagierlisteLadenCommand.IsEnabled = !string.IsNullOrEmpty(nameOderID);

      }
    }

    private void PassagierlisteLaden()
    {
      int id;
      if (int.TryParse(nameOderID, out id))
        wwwingsBuchungsserviceProxy.GetPassagierAsync(id);
      else
        wwwingsBuchungsserviceProxy.GetPassagiereAsync(nameOderID);
    }
  }
}
