﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using WWWings_GUI_SL5.Utilities;

namespace WWWings_GUI_SL5.ViewModels
{
  public class MainViewModel : NotifyPropertyChanged
  {
    private ViewModelBase activeViewModel;

    public ViewModelBase ActiveViewModel
    {
      get { return activeViewModel; }
      set { activeViewModel = value; OnPropertyChanged("ActiveViewModel"); }
    }

    private FlugauswahlViewModel flugauswahlViewModel;
    private PassagierauswahlViewModel passagierauswahlViewModel;
    private BuchungAbschließenViewModel buchungAbschließenViewModel;

    public MainViewModel()
    {
      flugauswahlViewModel = new FlugauswahlViewModel();
      passagierauswahlViewModel = new PassagierauswahlViewModel();
      buchungAbschließenViewModel = new BuchungAbschließenViewModel();

      WeiterCommand = new ActionCommand(Weiter);

      Zustände = new SelectableItem[] { new SelectableItem() { Value = "Flug auswählen" }, new SelectableItem() { Value = "Passagier auswählen" }, new SelectableItem() { Value = "Buchung abschließen" } };

      Neustart();
    }

    private void Neustart()
    {
      flugauswahlViewModel.Reset();
      passagierauswahlViewModel.Reset();
      buchungAbschließenViewModel.Reset();

      ActiveViewModel = flugauswahlViewModel;
      ZustandSetzen(0);
      WeiterCommand.Value = "Weiter";
    }

    private void ZustandSetzen(int neuerZustand)
    {
      for (int i = 0; i < Zustände.Length; i++)
      {
        Zustände[i].IsSelected = i == neuerZustand;
      }
      aktuellerZustand = neuerZustand;
    }

    public SelectableItem[] Zustände { get; set; }
    private int aktuellerZustand;

    public ActionCommand WeiterCommand { get; set; }
    private void Weiter()
    {
      switch (aktuellerZustand)
      {
        case 0:
          ActiveViewModel = passagierauswahlViewModel;
          ZustandSetzen(1);
          break;

        case 1:
          buchungAbschließenViewModel.AusgewählterFlug = flugauswahlViewModel.AusgewählterFlug;
          buchungAbschließenViewModel.AusgewählterPassagier = passagierauswahlViewModel.AusgewählterPassagier;
          ActiveViewModel = buchungAbschließenViewModel;
          ZustandSetzen(2);
          WeiterCommand.Value = "Neue Buchung";
          break;

        case 2:
          Neustart();
          break;
      }
    }
  }
}
