﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WWWings_GUI_SL5.WWWingsBuchungsserviceProxy;
using WWWings_GUI_SL5.Utilities;

namespace WWWings_GUI_SL5.ViewModels
{
  public class BuchungAbschließenViewModel : ViewModelBase
  {
    public BuchungAbschließenViewModel()
    {
      this.wwwingsBuchungsserviceProxy.CreateBuchungCompleted += new EventHandler<CreateBuchungCompletedEventArgs>(wwwingsBuchungsserviceProxy_CreateBuchungCompleted);
      BuchungAbschließenCommand = new ActionCommand(BuchungAbschließen);

    }

    void wwwingsBuchungsserviceProxy_CreateBuchungCompleted(object sender, CreateBuchungCompletedEventArgs e)
    {
      Status = e.Result;
      IsValid = true;

    }

    public override void Reset()
    {
      base.Reset();
      Status = "Bitte Eingaben prüfen und bestätigen";
      BuchungAbschließenCommand.IsEnabled = true;
    }

  

    private Flug ausgewählterFlug;

    public Flug AusgewählterFlug
    {
      get { return ausgewählterFlug; }
      set { ausgewählterFlug = value; OnPropertyChanged("AusgewählterFlug"); }
    }

    private Passagier ausgewählterPassagier;

    public Passagier AusgewählterPassagier
    {
      get { return ausgewählterPassagier; }
      set { ausgewählterPassagier = value; OnPropertyChanged("AusgewählterPassagier"); }
    }

    public ActionCommand BuchungAbschließenCommand { get; set; }
    private void BuchungAbschließen()
    {
      Status = "Buchung wird bearbeitet";
      BuchungAbschließenCommand.IsEnabled = false;
      wwwingsBuchungsserviceProxy.CreateBuchungAsync(ausgewählterFlug.ID, ausgewählterPassagier.ID);
    }

    private string status;

    public string Status
    {
      get { return status; }
      set { status = value; OnPropertyChanged("Status"); }
    }


  }
}
