﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace WWWings_GUI_SL5.Utilities
{
  public class Item : NotifyPropertyChanged
  {
    private object value;

    public object Value
    {
      get { return this.value; }
      set { this.value = value; OnPropertyChanged("Value"); }
    }

    private object tooltip;

    public object Tooltip
    {
      get { return tooltip; }
      set { tooltip = value; OnPropertyChanged("Tooltip"); }
    }

    private bool isEnabled = true;

    public bool IsEnabled
    {
      get { return isEnabled; }
      set
      {
        if (isEnabled != value)
        {
          isEnabled = value;
          OnPropertyChanged("IsEnabled");
          OnIsEnabledChanged();
        }
      }
    }

    protected virtual void OnIsEnabledChanged()
    {
    }


  }
}
