﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace WWWings_GUI_SL5.Utilities
{
  public class ActionCommand : Item, ICommand
  {
    private Action action;

    /// <summary>
    /// Konstruktor
    /// </summary>
    /// <param name="action">Delegate, das bei Command.Execute() ausgeführt werden soll</param>
    public ActionCommand(Action action)
    {
      this.action = action;
    }

    protected override void OnIsEnabledChanged()
    {
      if (CanExecuteChanged != null)
        CanExecuteChanged(this, EventArgs.Empty);
    }

    public bool CanExecute(object parameter)
    {
      return this.IsEnabled;
    }

    public event EventHandler CanExecuteChanged;

    public void Execute(object parameter)
    {
      if (action != null)
        action();
    }
  }
}
