﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WWWings_GO;

namespace WWWings_GL
{

 /// <summary>
 /// Geschäftslogik für Buchungskasen
 /// </summary>
 public class BuchungsManager : IDisposable
 {
  // Instanzen der Datenmanager
  WWWings_DZS.FlugDataManager fm = new WWWings_DZS.FlugDataManager(false);
  WWWings_DZS.PassagierDataManager pm = new WWWings_DZS.PassagierDataManager(false);

  public void Dispose()
  {
   fm.Dispose();
   pm.Dispose();
  }

  /// <summary>
  /// Einen Flug holen
  /// </summary>
  public Flug GetFlug(int FNummer)
  {
   return fm.GetFlug(FNummer);
  }

  /// <summary>
  /// Einen Passagier holen
  /// </summary>
  public Passagier GetPassagier(int PNummer)
  {
   return pm.GetPassagier(PNummer);
  }

  /// <summary>
  /// Eine Liste von Flügen holen
  /// </summary>
  public List<Flug> GetFluege(string Abflugort, string Zielort)
  {
   return fm.GetFluege(Abflugort, Zielort);
  }

  /// <summary>
  /// Eine Liste von Passagieren holen
  /// </summary>
  public List<Passagier> GetPassagiere(string Name)
  {
   return pm.GetPassagiere(Name);
  }

  /// <summary>
  /// Änderungen an einer Liste von Passagieren speichern
  /// </summary>
  public string SavePassagierSet(List<Passagier> PassagierSet)
  {
   return pm.SavePassagierSet(PassagierSet);
  }

  /// <summary>
  /// Flugbuchung erstellen
  /// </summary>
  public string CreateBuchung(int FlugID, int PassagierID)
  {
   try
   {

    // Transaktion, nur erfolgreich wenn Platzanzahl reduziert und Buchung erstellt!
    using (System.Transactions.TransactionScope t = new System.Transactions.TransactionScope())
    {
     // hier erfolgen Änderungen in Datenbanken über zwei Methoden der Datenzugriffsschicht
     if (!fm.ReducePlatzAnzahl(FlugID, 1)) return "Fehler: Kein Platz auf diesem Flug vorhanden!";
     if (!pm.AddPassagierZuFlug(PassagierID, FlugID)) return "Fehler: Buchung nicht möglich!";

     //  Transaktion erfolgreich abschließen
     t.Complete();

     // Buchungscode zurückgeben
     return "OK";
    }
   }
   catch (Exception ex)
   {
    return "Unerwarteter Fehler: " + ex.Message;
   }
  }

  public List<string> GetFlughäfen()
  {
    return fm.GetFlughäfen();
  }
 }
}

