﻿using System;

using Android.App;
using Android.Content;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.OS;

namespace AndroidCalcProg {
  [Activity(Label = "AndroidCalcProg", MainLauncher = true, Icon = "@drawable/icon")]
  public class MainActivity : Activity {
    int count = 1;

    EditText firstNumber;
    EditText secondNumber;
    EditText result;
    Button   plusButton;
    Button   minusButton;
    Button   divideButton;
    Button   multiplyButton;



    protected override void OnCreate(Bundle bundle) {
      base.OnCreate(bundle);

      // Set our view from the "main" layout resource
      SetContentView(Resource.Layout.Main);

      // Get our button from the layout resource,
      // and attach an event to it
      firstNumber = FindViewById<EditText> (Resource.Id.firstNumberEditText);
      secondNumber = FindViewById <EditText> (Resource.Id.secondNumberEditText);
      result = FindViewById<EditText>(Resource.Id.resultEditText);

      plusButton = FindViewById<Button>(Resource.Id.plusButton);
      minusButton = FindViewById<Button>(Resource.Id.minusButton);
      divideButton = FindViewById<Button>(Resource.Id.divideButton);
      multiplyButton = FindViewById<Button>(Resource.Id.multiplyButton);

      plusButton.Click += delegate {
        calc('+');
      };

      minusButton.Click += delegate {
        calc('-');
      };

      multiplyButton.Click += delegate {
        calc('*');
      };

      divideButton.Click += delegate {
        calc('/');
      };

    }

    private void calc(Char operation) {
      Double firstOperator, secondOperator;
      Double result;

      Double.TryParse(firstNumber.Text, out firstOperator);
      Double.TryParse(secondNumber.Text, out secondOperator);
      switch (operation) {
        case '+':
          result = firstOperator + secondOperator;
          break;
        case '-':
          result = firstOperator - secondOperator;
          break;
        case '*':
          result = firstOperator * secondOperator;
          break;
        default:
          result = firstOperator / secondOperator;
          break;
      }
      this.result.Text = String.Format("{0}", result);
    }
  }
}


