/*****************************************************************************
*  ADBotPlayerV1                                                             *
*                                                                            *
*  Copyright (C) 2008 Andreas Dittrich                                       *
*                                                                            *
*  Author:  Andreas Dittrich                                                 *
*           Am Schimmelberg 29                                               *
*           67729 Sippersfeld (Germany)                                      *
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <windows.h>
#include <vfw.h>
#include <dshow.h>
#include <string.h>

#include "inttypes.h"

#include "../interface/ADBotPlayerV1.h"

#include "vector2avi.h"



#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT (768+32)






#define MIN(a,b) ( (a)<(b) ? (a) : (b) )
#define MAX(a,b) ( (a)>(b) ? (a) : (b) )



#define NUM_BYTES_VECTOR_RAM 1024
	

// static constants
///////////////////

static const DWORD FOURCC_astd = mmioFOURCC('a','s','t','d');   



typedef struct {
	FILE *file_src;
	int AVIFile_is_initialized;
	PAVISTREAM videostream;
	PAVISTREAM audiostream;
	PAVIFILE avifile_dst;

	unsigned int videosample_index;
	int inputFrameNumber;

	uint8_t *pBuffer;
	int NumBytesBuffer;

} vector2avi_context_t;




void * vector2avi_open( char destination_filename_str[] )
{
	HRESULT hr;
	AVISTREAMINFO vsi;
	BITMAPINFOHEADER bih;

	vector2avi_context_t * h = (vector2avi_context_t*)malloc(sizeof(vector2avi_context_t));
	if (h==NULL)
		return NULL;

	memset(h, 0x00, sizeof(vector2avi_context_t));

	//create buffer
	h->NumBytesBuffer = ( (NUM_BYTES_VECTOR_RAM + sizeof(GameState_t) + 63)/64 )*64;
	h->pBuffer = (uint8_t*)malloc( h->NumBytesBuffer );
	if (h->pBuffer==NULL)
		goto Failed;

	// open avi lib
	AVIFileInit(); 
	h->AVIFile_is_initialized = 1;

	// create destination file
	hr = AVIFileOpenA(
		&h->avifile_dst,     
		destination_filename_str,
		OF_CREATE,
		NULL );

	if (hr!=0)
		goto Failed;

	// prepare video streaminfo structure
	{
		memset( &vsi, 0, sizeof(vsi) );

		vsi.fccType = streamtypeVIDEO;		//"vids"
		vsi.fccHandler = FOURCC_astd; 
		vsi.dwRate = 60; 
		vsi.dwScale = 1; 
		vsi.rcFrame.left = 0;
		vsi.rcFrame.right = SCREEN_WIDTH;
		vsi.rcFrame.top = 0;
		vsi.rcFrame.bottom = SCREEN_HEIGHT;
	}
	
	//create video stream
	hr = AVIFileCreateStream(
	  h->avifile_dst,      
	  &h->videostream,  
	  &vsi  
	);

	if (hr!=0)
		goto Failed;

	// prepare Bitmapinfoheader structure
	{
		memset( &bih, 0, sizeof(bih) );

		bih.biSize = sizeof(bih);
		bih.biWidth = SCREEN_WIDTH;
		bih.biHeight = vsi.rcFrame.bottom;
		bih.biPlanes = 1;
		bih.biBitCount = 32;
		bih.biCompression = FOURCC_astd;
		bih.biSizeImage = 0;
	}

	//set video format
	hr = AVIStreamSetFormat(
		h->videostream,
		0,
		&bih,
		sizeof(bih)
		);

	if (hr!=0)
		goto Failed;

	h->videosample_index = 0;

//Success
	return h;

Failed:
	vector2avi_close( h );
	
	return NULL;
}


int vector2avi_writeFrame( 
	void *hnd,
	int frameNumber,
	uint8_t *pVectorRam, 
	int NumBytesVectorRam,
	uint8_t *pAuxData,
	int NumBytesAuxData )
{
	vector2avi_context_t * h = (vector2avi_context_t*)hnd;
	if (h==NULL)
		return -1;

	if ( (pVectorRam==NULL) ||
		 (NumBytesVectorRam != NUM_BYTES_VECTOR_RAM) )
		return -2;

	uint8_t * pBuf = pVectorRam;
	int NumBytesBuf = NumBytesVectorRam;

	if ( (pAuxData!=NULL) && 
		 (NumBytesAuxData>0) &&
		 (NumBytesAuxData+NumBytesVectorRam <= h->NumBytesBuffer) )
	{
		memcpy( h->pBuffer, pVectorRam, NumBytesVectorRam );
		memcpy( h->pBuffer+NumBytesVectorRam, pAuxData, NumBytesAuxData );
		
		pBuf = h->pBuffer;
		NumBytesBuf = NumBytesAuxData + NumBytesVectorRam;
	}

	//write video sample
	HRESULT hr = AVIStreamWrite(
		h->videostream,
		h->videosample_index,
		1,
		pBuf,
		NumBytesBuf,
		AVIIF_KEYFRAME,
		NULL,
		NULL
	);

	if (hr!=0)
		return -3;

	h->videosample_index++;

	return 0;
}


void vector2avi_close( void *hnd )
{
	vector2avi_context_t * h = (vector2avi_context_t*)hnd;
	if (h==NULL)
		return;

	if (h->file_src) 
		fclose(h->file_src);

	if (h->videostream) 
		AVIStreamRelease(h->videostream);

	if (h->avifile_dst)
		AVIFileRelease(h->avifile_dst);

	if ( h->AVIFile_is_initialized ) 
		AVIFileExit();

	if ( h->pBuffer )
		free( h->pBuffer );

	free(h);
}

