/*****************************************************************************
*  ADBotPlayerV1                                                             *
*                                                                            *
*  Copyright (C) 2008 Andreas Dittrich                                       *
*                                                                            *
*  Author:  Andreas Dittrich                                                 *
*           Am Schimmelberg 29                                               *
*           67729 Sippersfeld (Germany)                                      *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "inttypes.h"
#include "vector.h"

#include "../interface/ADBotPlayerV1.h"
#include "ADBotPlayerV1_private.h"

#include "gamestate.h"
#include "gameinterface.h"
#include "player.h"

#include "botplayer.h"


static void exit_function( void );
static BOOL ctrl_handler( DWORD fdwCtrlType );
static DWORD WINAPI BotPlayerThreadProc(LPVOID lpParameter);


void * g_hGameInterface = NULL;
BotPlayer *g_pBotPlayer = NULL;


int main(int argc, char* argv[])
{
	int res;

	// init the console handling
	res = atexit( exit_function );
	if (res!=0)
		return -1;

	BOOL bResult = SetConsoleCtrlHandler(
		(PHANDLER_ROUTINE)ctrl_handler,
		TRUE );

	if (!bResult)
		return -1;

	//set error mode
	_set_error_mode(_OUT_TO_MSGBOX);

	// check arguments 
	if (argc != 2)
	{
		fprintf(stderr, "usage: ADBotPlayerV1 <IP-adress>\n");
		return 0;
	}

	// connect to the Game
	g_hGameInterface = GameInterface_open( argv[1] );
	if (g_hGameInterface==NULL)
		return -1;

	// create the BotPlayer
	g_pBotPlayer = new BotPlayer( g_hGameInterface, &res );
	if (res<0)
		return -1;


	#ifdef USE_SEPERATE_THREAD

	// create seperate thread for the player
	HANDLE hBotPlayerThread = CreateThread(
		NULL,
		NULL,
		BotPlayerThreadProc,
		(LPVOID)g_pBotPlayer,
		0,	// start immediately
		NULL
	);

	SetThreadPriority( hBotPlayerThread, MY_THREAD_PRIORITY );

	WaitForSingleObject( hBotPlayerThread, INFINITE );

	#else

	g_pBotPlayer->Run();

	#endif

	return 0;
}


static DWORD WINAPI BotPlayerThreadProc(LPVOID lpParameter)
{
	BotPlayer * pBotPlayer = (BotPlayer*)lpParameter;
	if (pBotPlayer==NULL)
		return (DWORD)(-1);

	return (DWORD)( pBotPlayer->Run() );
}


static void exit_function( void )
{
	if (g_pBotPlayer)
	{
		delete g_pBotPlayer;
		g_pBotPlayer = NULL;
	}

	if (g_hGameInterface)
	{
		GameInterface_close( g_hGameInterface );
		g_hGameInterface = NULL;
	}
}


static BOOL ctrl_handler( DWORD fdwCtrlType ) 
{ 
	switch( fdwCtrlType ) 
	{ 
	case CTRL_C_EVENT: 
	case CTRL_CLOSE_EVENT: 
	case CTRL_BREAK_EVENT: 
		if (g_pBotPlayer)
			g_pBotPlayer->Stop();

		return( TRUE ); 

	case CTRL_LOGOFF_EVENT: 
	case CTRL_SHUTDOWN_EVENT:
	default:
		return FALSE; 
	} 
} 
 
