/*
 * Created on Jun 17, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki.rater;

import com.dkaedv.asteroids.data.Asteroid;
import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.ki.ShotTargetList;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.util.VectorCalculations;

public class ShotTargetRater extends BaseTargetRater {
    private ShotTargetList shotTargetList;


    @Override
    public void rateTarget(GameStatus gameStatus, TargetList targetList,
            RatedTarget target) {

        if (gameStatus.getShip() != null
                && VectorCalculations.getDistance(gameStatus.getShip(), target.getTarget()) < 100) {
            // Too close - rate it fully
            rateIt(target, 100);
            return;
        }

        if (target.getTarget() instanceof Asteroid) {
            Asteroid a = (Asteroid) target.getTarget();
            if (a.getRadius() > 8) {
                // This is not a small asteroid, so multiple shots don't hurt
                rateIt(target, 100);
                return;
            }

        }

        if (! shotTargetList.wasShotOn(target.getTarget())) {
            rateIt(target, 100);
        }
    }


    /**
     * @param shotTargetList the shotTargetList to set
     */
    public void setShotTargetList(ShotTargetList shotTargetList) {
        this.shotTargetList = shotTargetList;
    }

}
